/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import net.sf.samtools.SAMFileHeader;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class GenomeLoc
implements Comparable<GenomeLoc>,
Serializable,
HasGenomeLocation {
    protected final int contigIndex;
    protected final int start;
    protected final int stop;
    protected final String contigName;
    public static final GenomeLoc UNMAPPED = new GenomeLoc(null);
    public static final GenomeLoc WHOLE_GENOME = new GenomeLoc("all");

    public static final boolean isUnmapped(GenomeLoc loc) {
        return loc == UNMAPPED;
    }

    @Requires(value={"contig != null", "contigIndex >= 0", "start <= stop"})
    protected GenomeLoc(String contig, int contigIndex, int start, int stop) {
        this.contigName = contig;
        this.contigIndex = contigIndex;
        this.start = start;
        this.stop = stop;
    }

    private GenomeLoc(String contig) {
        this.contigName = contig;
        this.contigIndex = -1;
        this.start = 0;
        this.stop = 0;
    }

    @Override
    @Ensures(value={"result != null"})
    public final GenomeLoc getLocation() {
        return this;
    }

    public final GenomeLoc getStartLocation() {
        return new GenomeLoc(this.getContig(), this.getContigIndex(), this.getStart(), this.getStart());
    }

    public final GenomeLoc getStopLocation() {
        return new GenomeLoc(this.getContig(), this.getContigIndex(), this.getStop(), this.getStop());
    }

    public final String getContig() {
        return this.contigName;
    }

    public final int getContigIndex() {
        return this.contigIndex;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getStop() {
        return this.stop;
    }

    @Ensures(value={"result != null"})
    public final String toString() {
        if (GenomeLoc.isUnmapped(this)) {
            return "unmapped";
        }
        if (this.throughEndOfContigP() && this.atBeginningOfContigP()) {
            return this.getContig();
        }
        if (this.throughEndOfContigP() || this.getStart() == this.getStop()) {
            return String.format("%s:%d", this.getContig(), this.getStart());
        }
        return String.format("%s:%d-%d", this.getContig(), this.getStart(), this.getStop());
    }

    private boolean throughEndOfContigP() {
        return this.stop == Integer.MAX_VALUE;
    }

    private boolean atBeginningOfContigP() {
        return this.start == 1;
    }

    @Requires(value={"that != null"})
    public final boolean disjointP(GenomeLoc that) {
        return this.contigIndex != that.contigIndex || this.start > that.stop || that.start > this.stop;
    }

    @Requires(value={"that != null"})
    public final boolean discontinuousP(GenomeLoc that) {
        return this.contigIndex != that.contigIndex || this.start - 1 > that.stop || that.start - 1 > this.stop;
    }

    @Requires(value={"that != null"})
    public final boolean overlapsP(GenomeLoc that) {
        return !this.disjointP(that);
    }

    @Requires(value={"that != null"})
    public final boolean contiguousP(GenomeLoc that) {
        return !this.discontinuousP(that);
    }

    public final boolean isUnmapped() {
        return GenomeLoc.isUnmapped(this);
    }

    @Requires(value={"that != null", "isUnmapped(this) == isUnmapped(that)"})
    @Ensures(value={"result != null"})
    public GenomeLoc merge(GenomeLoc that) throws ReviewedStingException {
        if (GenomeLoc.isUnmapped(this) || GenomeLoc.isUnmapped(that)) {
            if (!GenomeLoc.isUnmapped(this) || !GenomeLoc.isUnmapped(that)) {
                throw new ReviewedStingException("Tried to merge a mapped and an unmapped genome loc");
            }
            return UNMAPPED;
        }
        if (!this.contiguousP(that)) {
            throw new ReviewedStingException("The two genome loc's need to be contiguous");
        }
        return new GenomeLoc(this.getContig(), this.contigIndex, Math.min(this.getStart(), that.getStart()), Math.max(this.getStop(), that.getStop()));
    }

    @Requires(value={"that != null", "isUnmapped(this) == isUnmapped(that)"})
    @Ensures(value={"result != null"})
    public GenomeLoc endpointSpan(GenomeLoc that) throws ReviewedStingException {
        if (GenomeLoc.isUnmapped(this) || GenomeLoc.isUnmapped(that)) {
            throw new ReviewedStingException("Cannot get endpoint span for unmerged genome locs");
        }
        if (!this.getContig().equals(that.getContig())) {
            throw new ReviewedStingException("Cannot get endpoint span for genome locs on different contigs");
        }
        return new GenomeLoc(this.getContig(), this.contigIndex, Math.min(this.getStart(), that.getStart()), Math.max(this.getStop(), that.getStop()));
    }

    public GenomeLoc[] split(int splitPoint) {
        if (splitPoint < this.getStart() || splitPoint > this.getStop()) {
            throw new ReviewedStingException(String.format("Unable to split contig %s at split point %d; split point is not contained in region.", this, splitPoint));
        }
        return new GenomeLoc[]{new GenomeLoc(this.getContig(), this.contigIndex, this.getStart(), splitPoint - 1), new GenomeLoc(this.getContig(), this.contigIndex, splitPoint, this.getStop())};
    }

    public GenomeLoc union(GenomeLoc that) {
        return this.merge(that);
    }

    @Requires(value={"that != null"})
    @Ensures(value={"result != null"})
    public GenomeLoc intersect(GenomeLoc that) throws ReviewedStingException {
        if (GenomeLoc.isUnmapped(this) || GenomeLoc.isUnmapped(that)) {
            if (!GenomeLoc.isUnmapped(this) || !GenomeLoc.isUnmapped(that)) {
                throw new ReviewedStingException("Tried to intersect a mapped and an unmapped genome loc");
            }
            return UNMAPPED;
        }
        if (!this.overlapsP(that)) {
            throw new ReviewedStingException("GenomeLoc::intersect(): The two genome loc's need to overlap");
        }
        return new GenomeLoc(this.getContig(), this.contigIndex, Math.max(this.getStart(), that.getStart()), Math.min(this.getStop(), that.getStop()));
    }

    @Requires(value={"that != null"})
    public final List<GenomeLoc> subtract(GenomeLoc that) {
        if (GenomeLoc.isUnmapped(this) || GenomeLoc.isUnmapped(that)) {
            if (!GenomeLoc.isUnmapped(this) || !GenomeLoc.isUnmapped(that)) {
                throw new ReviewedStingException("Tried to intersect a mapped and an unmapped genome loc");
            }
            return Arrays.asList(UNMAPPED);
        }
        if (!this.overlapsP(that)) {
            throw new ReviewedStingException("GenomeLoc::minus(): The two genome loc's need to overlap");
        }
        if (this.equals(that)) {
            return Collections.emptyList();
        }
        if (this.containsP(that)) {
            ArrayList<GenomeLoc> l = new ArrayList<GenomeLoc>(2);
            int afterStop = this.getStop();
            int afterStart = that.getStop() + 1;
            int beforeStop = that.getStart() - 1;
            int beforeStart = this.getStart();
            if (afterStop - afterStart >= 0) {
                GenomeLoc after = new GenomeLoc(this.getContig(), this.getContigIndex(), afterStart, afterStop);
                l.add(after);
            }
            if (beforeStop - beforeStart >= 0) {
                GenomeLoc before = new GenomeLoc(this.getContig(), this.getContigIndex(), beforeStart, beforeStop);
                l.add(before);
            }
            return l;
        }
        if (that.containsP(this)) {
            return Collections.emptyList();
        }
        GenomeLoc n = that.getStart() < this.getStart() ? new GenomeLoc(this.getContig(), this.getContigIndex(), that.getStop() + 1, this.getStop()) : new GenomeLoc(this.getContig(), this.getContigIndex(), this.getStart(), that.getStart() - 1);
        return Arrays.asList(n);
    }

    @Requires(value={"that != null"})
    public final boolean containsP(GenomeLoc that) {
        return this.onSameContig(that) && this.getStart() <= that.getStart() && this.getStop() >= that.getStop();
    }

    @Requires(value={"that != null"})
    public final boolean onSameContig(GenomeLoc that) {
        return this.contigIndex == that.contigIndex;
    }

    @Requires(value={"that != null"})
    @Ensures(value={"result >= 0"})
    public final int distance(GenomeLoc that) {
        if (this.onSameContig(that)) {
            return Math.abs(this.getStart() - that.getStart());
        }
        return Integer.MAX_VALUE;
    }

    @Requires(value={"left != null", "right != null"})
    public final boolean isBetween(GenomeLoc left, GenomeLoc right) {
        return this.compareTo(left) > -1 && this.compareTo(right) < 1;
    }

    @Requires(value={"that != null"})
    public final boolean isBefore(GenomeLoc that) {
        int comparison = this.compareContigs(that);
        return comparison == -1 || comparison == 0 && this.getStop() < that.getStart();
    }

    @Requires(value={"that != null"})
    public final boolean startsAt(GenomeLoc that) {
        int comparison = this.compareContigs(that);
        return comparison == 0 && this.getStart() == that.getStart();
    }

    @Requires(value={"that != null"})
    public final boolean startsBefore(GenomeLoc that) {
        int comparison = this.compareContigs(that);
        return comparison == -1 || comparison == 0 && this.getStart() < that.getStart();
    }

    @Requires(value={"that != null"})
    public final boolean isPast(GenomeLoc that) {
        int comparison = this.compareContigs(that);
        return comparison == 1 || comparison == 0 && this.getStart() > that.getStop();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"result >= 0"})
    public final int minDistance(GenomeLoc that) {
        if (!this.onSameContig(that)) {
            return Integer.MAX_VALUE;
        }
        int minDistance = this.isBefore(that) ? GenomeLoc.distanceFirstStopToSecondStart(this, that) : (that.isBefore(this) ? GenomeLoc.distanceFirstStopToSecondStart(that, this) : 0);
        return minDistance;
    }

    @Requires(value={"locFirst != null", "locSecond != null", "locSecond.isPast(locFirst)"})
    @Ensures(value={"result >= 0"})
    private static int distanceFirstStopToSecondStart(GenomeLoc locFirst, GenomeLoc locSecond) {
        return locSecond.getStart() - locFirst.getStop();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof GenomeLoc) {
            GenomeLoc otherGenomeLoc = (GenomeLoc)other;
            return this.contigIndex == otherGenomeLoc.contigIndex && this.start == otherGenomeLoc.start && this.stop == otherGenomeLoc.stop;
        }
        return false;
    }

    public int hashCode() {
        return this.start << 16 | this.stop << 4 | this.contigIndex;
    }

    @Requires(value={"that != null"})
    @Ensures(value={"result == 0 || result == 1 || result == -1"})
    public final int compareContigs(GenomeLoc that) {
        if (this.contigIndex == that.contigIndex) {
            return 0;
        }
        if (this.contigIndex > that.contigIndex) {
            return 1;
        }
        return -1;
    }

    @Override
    @Requires(value={"that != null"})
    @Ensures(value={"result == 0 || result == 1 || result == -1"})
    public int compareTo(GenomeLoc that) {
        int result = 0;
        if (this == that) {
            result = 0;
        } else if (GenomeLoc.isUnmapped(this)) {
            result = 1;
        } else if (GenomeLoc.isUnmapped(that)) {
            result = -1;
        } else {
            int cmpContig = this.compareContigs(that);
            if (cmpContig != 0) {
                result = cmpContig;
            } else if (this.getStart() < that.getStart()) {
                result = -1;
            } else if (this.getStart() > that.getStart()) {
                result = 1;
            } else if (this.getStop() < that.getStop()) {
                result = -1;
            } else if (this.getStop() > that.getStop()) {
                result = 1;
            }
        }
        return result;
    }

    @Requires(value={"that != null"})
    public boolean endsAt(GenomeLoc that) {
        return this.compareContigs(that) == 0 && this.getStop() == that.getStop();
    }

    @Ensures(value={"result > 0"})
    public int size() {
        return this.stop - this.start + 1;
    }

    public final double reciprocialOverlapFraction(GenomeLoc o) {
        if (this.overlapsP(o)) {
            return Math.min(GenomeLoc.overlapPercent(this, o), GenomeLoc.overlapPercent(o, this));
        }
        return 0.0;
    }

    private static final double overlapPercent(GenomeLoc gl1, GenomeLoc gl2) {
        return 1.0 * (double)gl1.intersect(gl2).size() / (double)gl1.size();
    }

    public long sizeOfOverlap(GenomeLoc that) {
        return this.overlapsP(that) ? (long)(Math.min(this.getStop(), that.getStop()) - Math.max(this.getStart(), that.getStart())) + 1L : 0L;
    }

    public GenomeLoc max(GenomeLoc other) {
        int cmp = this.compareTo(other);
        return cmp == -1 ? other : this;
    }

    public GenomeLoc setStart(GenomeLoc loc, int start) {
        return new GenomeLoc(loc.getContig(), loc.getContigIndex(), start, loc.getStop());
    }

    public GenomeLoc setStop(GenomeLoc loc, int stop) {
        return new GenomeLoc(loc.getContig(), loc.getContigIndex(), loc.start, stop);
    }

    public GenomeLoc incPos(GenomeLoc loc) {
        return this.incPos(loc, 1);
    }

    public GenomeLoc incPos(GenomeLoc loc, int by) {
        return new GenomeLoc(loc.getContig(), loc.getContigIndex(), loc.start + by, loc.stop + by);
    }

    @Requires(value={"a != null && b != null"})
    public static <T extends GenomeLoc> GenomeLoc merge(T a, T b) {
        if (GenomeLoc.isUnmapped(a) || GenomeLoc.isUnmapped(b)) {
            throw new ReviewedStingException("Tried to merge unmapped genome locs");
        }
        if (!a.contiguousP(b)) {
            throw new ReviewedStingException("The two genome locs need to be contiguous");
        }
        return new GenomeLoc(a.getContig(), a.contigIndex, Math.min(a.getStart(), b.getStart()), Math.max(a.getStop(), b.getStop()));
    }

    @Requires(value={"sortedLocs != null"})
    public static <T extends GenomeLoc> GenomeLoc merge(SortedSet<T> sortedLocs) {
        GenomeLoc result = null;
        for (GenomeLoc loc : sortedLocs) {
            if (loc.isUnmapped()) {
                throw new ReviewedStingException("Tried to merge unmapped genome locs");
            }
            if (result == null) {
                result = loc;
                continue;
            }
            if (!result.contiguousP(loc)) {
                throw new ReviewedStingException("The genome locs need to be contiguous");
            }
            result = GenomeLoc.merge(result, loc);
        }
        return result;
    }

    public long distanceAcrossContigs(GenomeLoc other, SAMFileHeader samFileHeader) {
        if (this.onSameContig(other)) {
            return this.minDistance(other);
        }
        long distance = 0L;
        if (this.contigIndex < other.contigIndex) {
            distance += (long)(samFileHeader.getSequence(this.contigIndex).getSequenceLength() - this.stop);
            distance += (long)other.start;
        } else {
            distance += (long)(samFileHeader.getSequence(other.contigIndex).getSequenceLength() - other.stop);
            distance += (long)this.start;
        }
        for (int i = Math.min(this.contigIndex, other.contigIndex) + 1; i < Math.max(this.contigIndex, other.contigIndex); ++i) {
            distance += (long)samFileHeader.getSequence(i).getSequenceLength();
        }
        return distance;
    }
}

