/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;

class CycleFilesIterator
implements Iterator<File>,
Iterable<File> {
    private final File parentDir;
    private final int lane;
    private final int tile;
    private final String fileExt;
    protected final int[] cycles;
    protected int nextCycleIndex;

    public CycleFilesIterator(File laneDir, int lane, int tile, int[] cycles, String fileExt) {
        this.parentDir = laneDir;
        this.lane = lane;
        this.tile = tile;
        this.fileExt = fileExt;
        this.cycles = cycles;
        this.nextCycleIndex = 0;
    }

    CycleFilesIterator(CycleFilesIterator template, int[] cycles) {
        this(template.parentDir, template.lane, template.tile, cycles != null ? cycles : template.cycles, template.fileExt);
    }

    public void reset() {
        this.nextCycleIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextCycleIndex < this.cycles.length;
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.summarizeIterator());
        }
        File cycleDir = new File(this.parentDir, "C" + this.cycles[this.nextCycleIndex] + ".1");
        File curFile = new File(cycleDir, "s_" + this.lane + "_" + this.tile + this.fileExt);
        ++this.nextCycleIndex;
        return curFile;
    }

    public int getNextCycle() {
        return this.cycles[this.nextCycleIndex];
    }

    private String summarizeIterator() {
        String cyclesSummary = "";
        if (this.cycles.length > 0) {
            cyclesSummary = String.valueOf(this.cycles[0]);
            for (int i = 1; i < this.cycles.length; ++i) {
                cyclesSummary = cyclesSummary + ", " + String.valueOf(this.cycles[i]);
            }
        }
        return " Parent dir (" + this.parentDir.getAbsolutePath() + ")" + " Lane (" + this.lane + ") Tile (" + this.tile + ") FileExt(" + this.fileExt + ")" + " CycleIndex (" + this.nextCycleIndex + ")" + "Cycles(" + cyclesSummary + ")";
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + CycleFilesIterator.class.getName());
    }

    @Override
    public Iterator<File> iterator() {
        return this;
    }
}

