/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import edu.cornell.med.icb.goby.alignments.Alignments;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class ReadOriginInfo {
    private final List<Alignments.ReadOriginInfo> list;
    private final Object2ObjectAVLTreeMap<Integer, Alignments.ReadOriginInfo> map;

    public ReadOriginInfo(List<Alignments.ReadOriginInfo> list) {
        this.list = list;
        this.map = new Object2ObjectAVLTreeMap();
        for (Alignments.ReadOriginInfo roi : list) {
            this.map.put(roi.getOriginIndex(), roi);
        }
    }

    public List<Alignments.ReadOriginInfo> getPbList() {
        return this.list;
    }

    public Alignments.ReadOriginInfo getInfo(int readOriginIndex) {
        return this.map.get(readOriginIndex);
    }

    public ObjectArrayList<Alignments.ReadOriginInfo.Builder> getPBBuilderList() {
        ObjectArrayList<Alignments.ReadOriginInfo.Builder> result = new ObjectArrayList<Alignments.ReadOriginInfo.Builder>();
        for (Alignments.ReadOriginInfo e : this.list) {
            result.add(Alignments.ReadOriginInfo.newBuilder(e));
        }
        return result;
    }

    public int size() {
        return this.list.size();
    }
}

