/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReservoirDownsampler<T> {
    private final ArrayList<T> reservoir;
    private final int maxElements;

    public ReservoirDownsampler(int maxElements) {
        if (maxElements < 0) {
            throw new ReviewedStingException("Unable to work with an negative size collection of elements");
        }
        this.reservoir = new ArrayList(maxElements);
        this.maxElements = maxElements;
    }

    public T add(T element) {
        if (this.maxElements <= 0) {
            return element;
        }
        if (this.reservoir.size() < this.maxElements) {
            this.reservoir.add(element);
            return null;
        }
        int slot = GenomeAnalysisEngine.getRandomGenerator().nextInt(this.maxElements);
        if (slot >= 0 && slot < this.maxElements) {
            T displaced = this.reservoir.get(slot);
            this.reservoir.set(slot, element);
            return displaced;
        }
        return element;
    }

    public boolean addAll(Collection<? extends T> elements) {
        boolean added = false;
        for (T element : elements) {
            added |= this.add(element) != null;
        }
        return added;
    }

    public Collection<T> getDownsampledContents() {
        return this.reservoir;
    }

    public void clear() {
        this.reservoir.clear();
    }

    public boolean isEmpty() {
        return this.reservoir.isEmpty();
    }

    public int size() {
        return this.reservoir.size();
    }

    public Iterator<T> iterator() {
        return this.reservoir.iterator();
    }

    public boolean contains(Object o) {
        return this.reservoir.contains(o);
    }

    public boolean containsAll(Collection<?> elements) {
        return this.reservoir.containsAll(elements);
    }

    public boolean retainAll(Collection<?> elements) {
        return this.reservoir.retainAll(elements);
    }

    public boolean remove(Object o) {
        return this.reservoir.remove(o);
    }

    public boolean removeAll(Collection<?> elements) {
        return this.reservoir.removeAll(elements);
    }

    public Object[] toArray() {
        Object[] contents = new Object[this.reservoir.size()];
        this.reservoir.toArray(contents);
        return contents;
    }

    public <T> T[] toArray(T[] array) {
        return this.reservoir.toArray(array);
    }
}

