/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.hierarchy.SingleComponentHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicComponentPrinter
implements ComponentPrinter {
    private static final String INDENTATION = "  ";
    private static final ComponentMatcher ALWAYS_MATCHES = BasicComponentPrinter.alwaysMatches();
    private final ComponentHierarchy hierarchy;

    private static ComponentMatcher alwaysMatches() {
        return new ComponentMatcher(){

            public boolean matches(Component c) {
                return true;
            }
        };
    }

    public static ComponentPrinter printerWithNewAwtHierarchy() {
        return new BasicComponentPrinter(NewHierarchy.ignoreExistingComponents());
    }

    public static ComponentPrinter printerWithCurrentAwtHierarchy() {
        return new BasicComponentPrinter(new ExistingHierarchy());
    }

    protected BasicComponentPrinter(ComponentHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    protected final ComponentHierarchy hierarchy() {
        return this.hierarchy;
    }

    @Override
    @RunsInEDT
    public void printComponents(PrintStream out) {
        this.printComponents(out, ALWAYS_MATCHES);
    }

    @Override
    @RunsInEDT
    public void printComponents(PrintStream out, Container root) {
        this.printComponents(out, ALWAYS_MATCHES, root);
    }

    @Override
    @RunsInEDT
    public void printComponents(PrintStream out, Class<? extends Component> type) {
        this.printComponents(out, type, null);
    }

    @Override
    @RunsInEDT
    public void printComponents(PrintStream out, Class<? extends Component> type, Container root) {
        this.validateNotNull(out);
        if (type == null) {
            throw new NullPointerException("The type to match should not be null");
        }
        BasicComponentPrinter.print(this.hierarchy(root), new TypeMatcher(type), out);
    }

    @Override
    public void printComponents(PrintStream out, ComponentMatcher matcher) {
        this.printComponents(out, matcher, null);
    }

    @Override
    public void printComponents(PrintStream out, ComponentMatcher matcher, Container root) {
        this.validateNotNull(out);
        if (matcher == null) {
            throw new NullPointerException("The matcher to use as filter should not be null");
        }
        BasicComponentPrinter.print(this.hierarchy(root), matcher, out);
    }

    private void validateNotNull(PrintStream out) {
        if (out == null) {
            throw new NullPointerException("The output stream should not be null");
        }
    }

    private ComponentHierarchy hierarchy(Container root) {
        return root != null ? new SingleComponentHierarchy(root, this.hierarchy) : this.hierarchy;
    }

    @RunsInEDT
    private static void print(final ComponentHierarchy hierarchy, final ComponentMatcher matcher, final PrintStream out) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                for (Container container : hierarchy.roots()) {
                    BasicComponentPrinter.print(container, hierarchy, matcher, 0, out);
                }
            }
        });
    }

    @RunsInCurrentThread
    private static void print(Component c, ComponentHierarchy h, ComponentMatcher matcher, int level, PrintStream out) {
        if (matcher.matches(c)) {
            BasicComponentPrinter.print(c, level, out);
        }
        for (Component child : h.childrenOf(c)) {
            BasicComponentPrinter.print(child, h, matcher, level + 1, out);
        }
    }

    @RunsInCurrentThread
    private static void print(Component c, int level, PrintStream out) {
        for (int i = 0; i < level; ++i) {
            out.print(INDENTATION);
        }
        out.println(Formatting.format(c));
    }
}

