/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAMRecordDuplicateComparator
implements SAMRecordComparator {
    private static final byte FF = 0;
    private static final byte FR = 1;
    private static final byte F = 2;
    private static final byte RF = 3;
    private static final byte RR = 4;
    private static final byte R = 5;
    private final Map<String, Short> libraryIds = new HashMap<String, Short>();
    private short nextLibraryId = 1;
    private DuplicateScoringStrategy.ScoringStrategy scoringStrategy = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;

    public SAMRecordDuplicateComparator() {
    }

    public SAMRecordDuplicateComparator(List<SAMFileHeader> headers) {
        for (SAMFileHeader header : headers) {
            for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
                short libraryId;
                String libraryName = readGroup.getLibrary();
                if (null == libraryName) continue;
                this.nextLibraryId = (short)(this.nextLibraryId + 1);
                this.libraryIds.put(libraryName, libraryId);
            }
        }
    }

    public void setScoringStrategy(DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
        this.scoringStrategy = scoringStrategy;
    }

    private static String getLibraryName(SAMRecord rec) {
        String libraryName;
        SAMReadGroupRecord rg;
        String readGroupId = (String)rec.getAttribute("RG");
        if (readGroupId != null && (rg = rec.getHeader().getReadGroup(readGroupId)) != null && null != (libraryName = rg.getLibrary())) {
            return libraryName;
        }
        return "Unknown Library";
    }

    private short getLibraryId(SAMRecord rec) {
        String library = SAMRecordDuplicateComparator.getLibraryName(rec);
        Short libraryId = this.libraryIds.get(library);
        if (libraryId == null) {
            short s = this.nextLibraryId;
            this.nextLibraryId = (short)(s + 1);
            libraryId = s;
            this.libraryIds.put(library, libraryId);
        }
        return libraryId;
    }

    private int compareOrientationByteCollapseOrientation(int orientation1, int orientation2) {
        if (2 == orientation1 || 5 == orientation1) {
            if (2 == orientation1 ? 2 == orientation2 || 1 == orientation2 || 0 == orientation2 : 5 == orientation2 || 3 == orientation2 || 4 == orientation2) {
                return 0;
            }
        } else if (2 == orientation2 || 5 == orientation2) {
            return -this.compareOrientationByteCollapseOrientation(orientation2, orientation1);
        }
        return orientation1 - orientation2;
    }

    private static byte getPairedOrientationByte(boolean read1NegativeStrand, boolean read2NegativeStrand) {
        if (read1NegativeStrand) {
            if (read2NegativeStrand) {
                return 4;
            }
            return 3;
        }
        if (read2NegativeStrand) {
            return 1;
        }
        return 0;
    }

    private int getFragmentOrientation(SAMRecord record) {
        return record.getReadNegativeStrandFlag() ? 5 : 2;
    }

    private int getPairedOrientation(SAMRecord record) {
        if (record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag()) {
            return SAMRecordDuplicateComparator.getPairedOrientationByte(record.getReadNegativeStrandFlag(), record.getMateNegativeStrandFlag());
        }
        return this.getFragmentOrientation(record);
    }

    private int getMateReferenceIndex(SAMRecord record) {
        if (record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag()) {
            return record.getMateReferenceIndex();
        }
        return -1;
    }

    private int getMateCoordinate(SAMRecord record) {
        if (record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag()) {
            return record.getMateNegativeStrandFlag() ? SAMUtils.getMateUnclippedEnd(record) : SAMUtils.getMateUnclippedStart(record);
        }
        return -1;
    }

    private boolean hasUnmappedEnd(SAMRecord record) {
        return record.getReadUnmappedFlag() || record.getReadPairedFlag() && record.getMateUnmappedFlag();
    }

    private boolean hasMappedEnd(SAMRecord record) {
        return !record.getReadUnmappedFlag() || record.getReadPairedFlag() && !record.getMateUnmappedFlag();
    }

    private boolean pairedEndAndBothMapped(SAMRecord record) {
        return record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag();
    }

    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.fileOrderCompare(samRecord1, samRecord2);
        if (cmp == 0) {
            cmp = DuplicateScoringStrategy.compare(samRecord1, samRecord2, this.scoringStrategy, true);
        }
        if (cmp == 0) {
            cmp = samRecord1.getReadName().compareTo(samRecord2.getReadName());
        }
        if (cmp == 0 && samRecord1.getReadPairedFlag() && samRecord2.getReadPairedFlag()) {
            int samRecord1Value = samRecord1.getFirstOfPairFlag() ? 0 : 1;
            int samRecord2Value = samRecord2.getFirstOfPairFlag() ? 0 : 1;
            cmp = samRecord1Value - samRecord2Value;
        }
        return cmp;
    }

    private int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2, boolean collapseOrientation, boolean considerNumberOfEndsMappedAndPairing) {
        int samRecord2Value;
        int samRecord1Value = this.getLibraryId(samRecord1);
        int cmp = samRecord1Value - (samRecord2Value = this.getLibraryId(samRecord2));
        if (cmp == 0) {
            samRecord1Value = samRecord1.getReferenceIndex();
            samRecord2Value = samRecord2.getReferenceIndex();
            cmp = samRecord1Value == -1 ? (samRecord2Value == -1 ? 0 : 1) : (samRecord2Value == -1 ? -1 : samRecord1Value - samRecord2Value);
        }
        if (cmp == 0) {
            samRecord1Value = samRecord1.getReadNegativeStrandFlag() ? samRecord1.getUnclippedEnd() : samRecord1.getUnclippedStart();
            samRecord2Value = samRecord2.getReadNegativeStrandFlag() ? samRecord2.getUnclippedEnd() : samRecord2.getUnclippedStart();
            cmp = samRecord1Value - samRecord2Value;
        }
        if (cmp == 0) {
            samRecord1Value = this.getPairedOrientation(samRecord1);
            samRecord2Value = this.getPairedOrientation(samRecord2);
            cmp = collapseOrientation ? this.compareOrientationByteCollapseOrientation(samRecord1Value, samRecord2Value) : samRecord1Value - samRecord2Value;
        }
        if (this.pairedEndAndBothMapped(samRecord1) && this.pairedEndAndBothMapped(samRecord2)) {
            if (cmp == 0) {
                samRecord1Value = this.getMateReferenceIndex(samRecord1);
                samRecord2Value = this.getMateReferenceIndex(samRecord2);
                cmp = samRecord1Value - samRecord2Value;
            }
            if (cmp == 0) {
                samRecord1Value = this.getMateCoordinate(samRecord1);
                samRecord2Value = this.getMateCoordinate(samRecord2);
                cmp = samRecord1Value - samRecord2Value;
            }
        }
        if (cmp == 0) {
            samRecord1Value = this.hasMappedEnd(samRecord1) ? 0 : 1;
            samRecord2Value = this.hasMappedEnd(samRecord2) ? 0 : 1;
            cmp = samRecord1Value - samRecord2Value;
        }
        if (cmp == 0 && considerNumberOfEndsMappedAndPairing) {
            if (samRecord1.getReadPairedFlag() == samRecord2.getReadPairedFlag()) {
                samRecord1Value = this.hasUnmappedEnd(samRecord1) ? 1 : 0;
                samRecord2Value = this.hasUnmappedEnd(samRecord2) ? 1 : 0;
                cmp = samRecord1Value - samRecord2Value;
            } else {
                cmp = samRecord1.getReadPairedFlag() ? -1 : 1;
            }
        }
        return cmp;
    }

    public int duplicateSetCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
        return this.fileOrderCompare(samRecord1, samRecord2, true, false);
    }

    @Override
    public int fileOrderCompare(SAMRecord samRecord1, SAMRecord samRecord2) {
        return this.fileOrderCompare(samRecord1, samRecord2, false, true);
    }
}

