/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.CallSet;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.ConsensusMaker;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.ConsensusSummarizer;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.MongoDBManager;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.NA12878DBArgumentCollection;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.SiteIterator;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.SiteManager;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.errors.InvalidRecordsRemove;
import org.broadinstitute.gatk.utils.GenomeLocParser;

public class NA12878KnowledgeBase {
    private static final Logger logger = Logger.getLogger(NA12878KnowledgeBase.class);
    protected DBCollection sites;
    protected DBCollection callSets;
    protected DBCollection consensusSites;
    protected GenomeLocParser parser;
    private final MongoDBManager.Locator dblocator;

    public NA12878KnowledgeBase(GenomeLocParser parser, NA12878DBArgumentCollection args) {
        this.parser = parser;
        this.dblocator = args.getLocator();
        MongoDBManager.DBWrapper dbWrapper = MongoDBManager.getDB(this.dblocator);
        this.sites = dbWrapper.getSites();
        this.sites.setObjectClass(MongoVariantContext.class);
        this.sites.ensureIndex(this.sitesOrder());
        this.sites.ensureIndex(this.essentialIndex());
        this.callSets = dbWrapper.getCallsets();
        this.callSets.setObjectClass(CallSet.class);
        this.consensusSites = dbWrapper.getConsensus();
        this.consensusSites.setObjectClass(MongoVariantContext.class);
        this.consensusSites.ensureIndex(this.sitesOrder());
        this.consensusSites.ensureIndex(this.essentialIndex());
        dbWrapper.getMongo().setWriteConcern(WriteConcern.SAFE);
        if (args.resetDB) {
            this.reset();
        }
    }

    public void close() {
        MongoDBManager.getDB(this.dblocator).close();
    }

    public void delete() {
        MongoDBManager.getDB(this.dblocator).delete();
    }

    protected void printStatus() {
        this.printCollectionStatus("sites", this.sites);
        this.printCollectionStatus("callsets", this.callSets);
        this.printCollectionStatus("consensus", this.consensusSites);
    }

    private void printCollectionStatus(String name, DBCollection collection) {
        logger.info((Object)("Number of " + name + ":" + collection.getCount()));
        for (DBObject object : collection.find()) {
            logger.info((Object)("        " + object));
        }
    }

    public void reset() {
        logger.warn((Object)("Resetting all documents in " + this));
        this.sites.drop();
        this.callSets.drop();
        this.clearConsensus();
    }

    public void clearConsensus() {
        this.consensusSites.drop();
    }

    public WriteResult addCallset(CallSet callSet) {
        return this.callSets.insert(new DBObject[]{callSet});
    }

    public List<CallSet> getCallSets() {
        LinkedList<CallSet> callsets = new LinkedList<CallSet>();
        for (DBObject obj : this.callSets.find()) {
            callsets.add((CallSet)obj);
        }
        return callsets;
    }

    public CallSet getCallSet(String name) {
        BasicDBObject query = new BasicDBObject("Name", (Object)name);
        return (CallSet)this.callSets.findOne((DBObject)query);
    }

    public WriteResult addCall(MongoVariantContext mvc) {
        return this.sites.insert(new DBObject[]{mvc});
    }

    public List<WriteResult> removeCall(MongoVariantContext mvc) {
        HashSet matchKeys = new HashSet(mvc.keySet());
        matchKeys.remove("Date");
        matchKeys.remove("_id");
        BasicDBObject matchObject = new BasicDBObject();
        for (String key : matchKeys) {
            matchObject.put(key, mvc.get(key));
        }
        DBCursor cursor = this.sites.find((DBObject)matchObject);
        ArrayList<WriteResult> results = new ArrayList<WriteResult>(cursor.size());
        for (DBObject next : cursor) {
            results.add(this.sites.remove(next));
        }
        return results;
    }

    public void addCalls(Collection<MongoVariantContext> mvcs) {
        for (MongoVariantContext mvc : mvcs) {
            this.addCall(mvc);
        }
    }

    private DBObject essentialIndex() {
        BasicDBObject sortOrder = new BasicDBObject();
        sortOrder.put("Chr", (Object)1);
        sortOrder.put("Start", (Object)1);
        return sortOrder;
    }

    protected DBCollection getSitesCollection() {
        return this.sites;
    }

    public DBObject sitesOrder() {
        BasicDBObject sortOrder = new BasicDBObject();
        sortOrder.put("Chr", (Object)1);
        sortOrder.put("Start", (Object)1);
        sortOrder.put("Stop", (Object)1);
        sortOrder.put("Ref", (Object)1);
        sortOrder.put("Alt", (Object)1);
        return sortOrder;
    }

    protected SiteIterator<MongoVariantContext> getCalls() {
        return this.getCalls(new SiteManager(this.parser));
    }

    public SiteIterator<MongoVariantContext> getCalls(SiteManager manager) {
        DBObject sortOrder = this.sitesOrder();
        SiteIterator<MongoVariantContext> it = manager.getIterator(this.sites, sortOrder);
        it.setErrorHandler(new InvalidRecordsRemove(this.sites));
        return it;
    }

    public SiteIterator<MongoVariantContext> getConsensusSites(SiteManager manager) {
        return manager.getIterator(this.consensusSites, this.sitesOrder());
    }

    public ConsensusSummarizer updateConsensus(SiteManager manager, boolean tryToRemove) {
        return this.updateConsensus(manager, Priority.DEBUG, tryToRemove);
    }

    public ConsensusSummarizer updateConsensus(SiteManager manager, Priority logPriority, boolean tryToRemove) {
        ConsensusSummarizer summary = new ConsensusSummarizer();
        SiteIterator<MongoVariantContext> siteIterator = this.getCalls(manager);
        while (siteIterator.hasNext()) {
            List<MongoVariantContext> callsAtSite = siteIterator.getNextEquivalents();
            MongoVariantContext consensus = new ConsensusMaker().makeConsensus(callsAtSite);
            this.updateConsensusInDB(consensus, tryToRemove);
            logger.log(logPriority, (Object)("Updating consensus at site " + consensus));
            summary.add(consensus);
        }
        return summary;
    }

    private WriteResult updateConsensusInDB(MongoVariantContext site, boolean tryToRemove) {
        if (tryToRemove) {
            this.consensusSites.remove(NA12878KnowledgeBase.consensusSiteQuery(site));
        }
        return this.consensusSites.insert(new DBObject[]{site});
    }

    private static DBObject consensusSiteQuery(MongoVariantContext site) {
        LinkedList<BasicDBObject> conditions = new LinkedList<BasicDBObject>();
        conditions.add(new BasicDBObject("Chr", (Object)site.getChr()));
        conditions.add(new BasicDBObject("Start", (Object)site.getStart()));
        conditions.add(new BasicDBObject("Stop", (Object)site.getStop()));
        conditions.add(new BasicDBObject("Ref", (Object)site.getRef()));
        conditions.add(new BasicDBObject("Alt", (Object)site.getAlt()));
        BasicDBObject query = new BasicDBObject("$and", conditions);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query " + query));
        }
        return query;
    }

    public int writeReviews(VariantContextWriter writer, SiteManager manager) {
        return this.writeSelectedSites(writer, manager.onlyReviewed());
    }

    public int writeSelectedSites(VariantContextWriter writer, SiteManager manager) {
        writer.writeHeader(this.makeStandardVCFHeader());
        int counter = 0;
        for (MongoVariantContext vc : this.getCalls(manager)) {
            writer.add(vc.getVariantContext());
            ++counter;
        }
        return counter;
    }

    public VCFHeader makeStandardVCFHeader() {
        HashSet<VCFHeaderLine> metadata = new HashSet<VCFHeaderLine>();
        for (VCFHeaderLine line : MongoVariantContext.reviewHeaderLines()) {
            metadata.add(line);
        }
        VCFStandardHeaderLines.addStandardFormatLines(metadata, (boolean)true, (String[])new String[]{"GT", "DP", "GQ"});
        return new VCFHeader(metadata, Collections.singleton("NA12878"));
    }

    public String toString() {
        return String.format("NA12878KnowledgeBase{%s}", this.dblocator);
    }

    public static enum InputCallsetConfidence {
        REVIEW(0.99),
        TRUSTED_CALLSET(0.95),
        UNTRUSTED_CALLSET(0.75),
        UNKNOWN(0.0);

        public double confidence;

        private InputCallsetConfidence(double confidence) {
            this.confidence = confidence;
        }
    }
}

