/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

class CachedLookAndFeel
extends LookAndFeel {
    static ClassLoader currentLoader;
    UIDefaults customDefaults = new CustomUIDefaults();

    public static void install() {
        try {
            Method method = UIManager.class.getDeclaredMethod("getLAFState", new Class[]{null});
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[]{null});
            Field field = object.getClass().getDeclaredField("multiLookAndFeel");
            field.setAccessible(true);
            CachedLookAndFeel cachedLookAndFeel = new CachedLookAndFeel();
            field.set(object, cachedLookAndFeel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "CachedLookAndFeel";
    }

    @Override
    public String getID() {
        return "CachedLookAndFeel";
    }

    @Override
    public String getDescription() {
        return "Provide customized behaviour for getUI() method";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public UIDefaults getDefaults() {
        return this.customDefaults;
    }

    public static void installJideExtension(ClassLoader classLoader) {
        CachedLookAndFeel.installJideExtension(classLoader, false);
    }

    public static void installJideExtension(ClassLoader classLoader, boolean bl) {
        if (currentLoader == classLoader && !bl) {
            return;
        }
        try {
            Class<?> clazz = classLoader.loadClass("com.jidesoft.plaf.LookAndFeelFactory");
            Method method = clazz.getDeclaredMethod("installJideExtension", Integer.TYPE);
            int n = LookAndFeelFactory.getDefaultStyle();
            UIManager.put("jidesoft.extensionInstalled", null);
            method.invoke(null, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        currentLoader = classLoader;
        UIManager.put("ClassLoader", classLoader);
    }

    public static void reinstallJideExtension() {
        CachedLookAndFeel.installJideExtension(currentLoader, true);
    }

    private static void removeCachedClass(UIDefaults uIDefaults, Class clazz) {
        if (clazz != null) {
            uIDefaults.remove(clazz.getName());
            uIDefaults.remove(clazz);
        }
    }

    static class CustomUIDefaults
    extends UIDefaults {
        private static final long serialVersionUID = -6034471887061473005L;

        CustomUIDefaults() {
        }

        @Override
        public ComponentUI getUI(JComponent jComponent) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            String string = (String)uIDefaults.get(jComponent.getUIClassID());
            Class clazz = string != null ? (Class)uIDefaults.get(string) : null;
            ClassLoader classLoader = clazz != null ? clazz.getClassLoader() : null;
            ClassLoader classLoader2 = jComponent.getClass().getClassLoader();
            ClassLoader classLoader3 = (ClassLoader)UIManager.get("ClassLoader");
            if (classLoader2 == null) {
                if (classLoader != null && classLoader != classLoader3) {
                    CachedLookAndFeel.removeCachedClass(uIDefaults, clazz);
                }
                return null;
            }
            if (classLoader2 != classLoader || classLoader2 != classLoader3) {
                if (classLoader != null) {
                    CachedLookAndFeel.removeCachedClass(uIDefaults, clazz);
                }
                CachedLookAndFeel.installJideExtension(classLoader2);
            }
            return null;
        }
    }
}

