/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class BitSetUtils {
    private static final byte NBITS_LONG_REPRESENTATION = 64;
    private static final byte NBITS_SHORT_REPRESENTATION = 16;
    private static final Map<Short, BitSet> shortCache = new HashMap<Short, BitSet>(65534);

    public static long longFrom(BitSet bitSet) {
        return BitSetUtils.longFrom(bitSet, 64);
    }

    public static short shortFrom(BitSet bitSet) {
        return (short)BitSetUtils.longFrom(bitSet, 16);
    }

    public static long longFrom(BitSet bitSet, int nBits) {
        long number = 0L;
        int bitIndex = bitSet.nextSetBit(0);
        while (bitIndex >= 0 && bitIndex <= nBits) {
            number |= 1L << bitIndex;
            bitIndex = bitSet.nextSetBit(bitIndex + 1);
        }
        return number;
    }

    public static BitSet bitSetFrom(long number) {
        return BitSetUtils.bitSetFrom(number, 64);
    }

    public static BitSet bitSetFrom(short number) {
        BitSet result = shortCache.get(number);
        if (result == null) {
            result = BitSetUtils.bitSetFrom(number, 16);
            shortCache.put(number, result);
        }
        return result;
    }

    public static BitSet bitSetFrom(long number, int nBits) {
        BitSet bitSet = new BitSet(nBits);
        boolean isNegative = number < 0L;
        int bitIndex = 0;
        while (number != 0L) {
            if (number % 2L != 0L) {
                bitSet.set(bitIndex);
            }
            ++bitIndex;
            number /= 2L;
        }
        if (isNegative) {
            boolean foundFirstSetBit = false;
            for (int i = bitSet.nextSetBit(0); i < nBits && i >= 0; ++i) {
                boolean bit = bitSet.get(i);
                if (!foundFirstSetBit && bit) {
                    foundFirstSetBit = true;
                    continue;
                }
                if (!foundFirstSetBit) continue;
                bitSet.flip(i);
            }
        }
        return bitSet;
    }
}

