/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import java.util.Arrays;
import java.util.Comparator;

public class SubstitutionMatrix {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84, 78};
    private static final byte[] BASES_LC = new byte[]{97, 99, 103, 116, 110};
    private static final byte[] ORDER = new byte[255];
    private byte[] bytes = new byte[5];
    private final byte[][] codes = new byte[255][255];
    private final byte[][] bases = new byte[255][255];
    private static final Comparator<SubCode> comparator;

    /*
     * WARNING - void declaration
     */
    public SubstitutionMatrix(long[][] frequencies) {
        void var2_5;
        for (byte base : BASES) {
            this.bytes[SubstitutionMatrix.ORDER[base]] = this.rank(base, frequencies[base]);
        }
        for (byte[] base : this.bases) {
            Arrays.fill(base, (byte)78);
        }
        boolean bl = false;
        while (var2_5 < BASES.length) {
            byte r = BASES[var2_5];
            for (byte b : BASES) {
                if (r == b) continue;
                this.bases[r][this.codes[r][b]] = b;
                this.bases[SubstitutionMatrix.BASES_LC[var2_5]][this.codes[r][b]] = b;
            }
            ++var2_5;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte r : "ACGTN".getBytes()) {
            stringBuilder.append((char)r);
            stringBuilder.append(':');
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append((char)this.bases[r][i]);
            }
            stringBuilder.append('\t');
        }
        return stringBuilder.toString();
    }

    public SubstitutionMatrix(byte[] matrix) {
        this.bytes = matrix;
        for (byte[] base : this.bases) {
            Arrays.fill(base, (byte)78);
        }
        this.bases[65][this.bytes[0] >> 6 & 3] = 67;
        this.bases[65][this.bytes[0] >> 4 & 3] = 71;
        this.bases[65][this.bytes[0] >> 2 & 3] = 84;
        this.bases[65][this.bytes[0] & 3] = 78;
        System.arraycopy(this.bases[65], 0, this.bases[97], 0, 4);
        this.bases[67][this.bytes[1] >> 6 & 3] = 65;
        this.bases[67][this.bytes[1] >> 4 & 3] = 71;
        this.bases[67][this.bytes[1] >> 2 & 3] = 84;
        this.bases[67][this.bytes[1] & 3] = 78;
        System.arraycopy(this.bases[67], 0, this.bases[99], 0, 4);
        this.bases[71][this.bytes[2] >> 6 & 3] = 65;
        this.bases[71][this.bytes[2] >> 4 & 3] = 67;
        this.bases[71][this.bytes[2] >> 2 & 3] = 84;
        this.bases[71][this.bytes[2] & 3] = 78;
        System.arraycopy(this.bases[71], 0, this.bases[103], 0, 4);
        this.bases[84][this.bytes[3] >> 6 & 3] = 65;
        this.bases[84][this.bytes[3] >> 4 & 3] = 67;
        this.bases[84][this.bytes[3] >> 2 & 3] = 71;
        this.bases[84][this.bytes[3] & 3] = 78;
        System.arraycopy(this.bases[84], 0, this.bases[116], 0, 4);
        this.bases[78][this.bytes[4] >> 6 & 3] = 65;
        this.bases[78][this.bytes[4] >> 4 & 3] = 67;
        this.bases[78][this.bytes[4] >> 2 & 3] = 71;
        this.bases[78][this.bytes[4] & 3] = 84;
        for (byte refBase : BASES) {
            for (int code = 0; code < 4; code = (int)((byte)(code + 1))) {
                this.codes[refBase][this.bases[refBase][code]] = code;
            }
        }
    }

    public byte[] getEncodedMatrix() {
        return this.bytes;
    }

    private byte rank(byte refBase, long[] frequencies) {
        SubCode[] subCodes = new SubCode[4];
        int i = 0;
        byte[] byArray = BASES;
        int n = byArray.length;
        for (int j = 0; j < n; ++j) {
            byte base = byArray[j];
            if (refBase == base) continue;
            subCodes[i++] = new SubCode(base, frequencies[base]);
        }
        Arrays.sort(subCodes, comparator);
        for (i = 0; i < subCodes.length; i = (int)((byte)(i + 1))) {
            subCodes[i].rank = (byte)i;
        }
        for (SubCode subCode1 : subCodes) {
            subCode1.freq = 0L;
        }
        Arrays.sort(subCodes, comparator);
        byte rank = 0;
        for (SubCode subCode : subCodes) {
            rank = (byte)(rank << 2);
            rank = (byte)(rank | subCode.rank);
        }
        for (SubCode s : subCodes) {
            this.codes[refBase][s.base] = s.rank;
        }
        return rank;
    }

    public byte code(byte refBase, byte readBase) {
        return this.codes[refBase][readBase];
    }

    public byte base(byte refBase, byte code) {
        return this.bases[refBase][code];
    }

    static {
        Arrays.fill(ORDER, (byte)-1);
        SubstitutionMatrix.ORDER[65] = 0;
        SubstitutionMatrix.ORDER[67] = 1;
        SubstitutionMatrix.ORDER[71] = 2;
        SubstitutionMatrix.ORDER[84] = 3;
        SubstitutionMatrix.ORDER[78] = 4;
        comparator = new Comparator<SubCode>(){

            @Override
            public int compare(SubCode o1, SubCode o2) {
                if (o1.freq != o2.freq) {
                    return (int)(o2.freq - o1.freq);
                }
                return ORDER[o1.base] - ORDER[o2.base];
            }
        };
    }

    private static class SubCode {
        final byte base;
        long freq;
        byte rank;

        public SubCode(byte base, long freq) {
            this.base = base;
            this.freq = freq;
        }
    }
}

