/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;

public class AbstractRecordAndOffset {
    protected final SAMRecord record;
    protected final int offset;

    public AbstractRecordAndOffset(SAMRecord record, int offset) {
        this.offset = offset;
        this.record = record;
    }

    public int getOffset() {
        return this.offset;
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    public byte getReadBase() {
        return this.record.getReadBases()[this.offset];
    }

    public int getLength() {
        return 1;
    }

    public String getReadName() {
        return this.record.getReadName();
    }

    public byte[] getBaseQualities() {
        return this.record.getBaseQualities();
    }

    public byte getBaseQuality() {
        return this.record.getBaseQualities()[this.offset];
    }

    protected void validateOffset(int offset, byte[] array) {
        if (offset < 0 || offset >= array.length) {
            throw new IllegalArgumentException("The requested position is not covered by this " + this.getClass().getSimpleName() + " object.");
        }
    }
}

