/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OptionalMessageDialog
extends MessageDialog {
    private static final String STORE_ID = "OptionalMessageDialog.hide.";
    private static final String KEY_DETAIL = ".detail";
    public static final int NOT_SHOWN = 1025;
    public static final int NO_DETAIL = -1;
    private Button fHideDialogCheckBox;
    private String fId;
    private String fHideMessage;

    public static int open(String id, Shell parent, String title, Image titleImage, String message, int dialogType, String[] buttonLabels, int defaultButtonIndex) {
        if (!OptionalMessageDialog.isDialogEnabled(id)) {
            return 1025;
        }
        OptionalMessageDialog dialog = new OptionalMessageDialog(id, parent, title, titleImage, message, dialogType, buttonLabels, defaultButtonIndex);
        return dialog.open();
    }

    protected OptionalMessageDialog(String id, Shell parent, String title, Image titleImage, String message, int dialogType, String[] buttonLabels, int defaultButtonIndex) {
        super(parent, title, titleImage, message, dialogType, buttonLabels, defaultButtonIndex);
        this.fId = id;
        switch (dialogType) {
            case 3: 
            case 6: {
                this.fHideMessage = CUIMessages.OptionalMessageDialog_rememberDecision;
                break;
            }
            default: {
                this.fHideMessage = CUIMessages.OptionalMessageDialog_dontShowAgain;
            }
        }
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fHideDialogCheckBox = new Button(composite, 16416);
        this.fHideDialogCheckBox.setText(this.fHideMessage);
        this.fHideDialogCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalMessageDialog.setDialogEnabled(OptionalMessageDialog.this.fId, !((Button)e.widget).getSelection());
            }
        });
        OptionalMessageDialog.applyDialogFont((Control)this.fHideDialogCheckBox);
        return this.fHideDialogCheckBox;
    }

    private static IDialogSettings getDialogSettings() {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        if ((settings = settings.getSection(STORE_ID)) == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(STORE_ID);
        }
        return settings;
    }

    public static boolean isDialogEnabled(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        return !settings.getBoolean(key);
    }

    public static void setDialogDetail(String key, int detail) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        settings.put(String.valueOf(key) + KEY_DETAIL, detail);
    }

    public static int getDialogDetail(String key) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        try {
            return settings.getInt(String.valueOf(key) + KEY_DETAIL);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static void setDialogEnabled(String key, boolean isEnabled) {
        IDialogSettings settings = OptionalMessageDialog.getDialogSettings();
        settings.put(key, !isEnabled);
    }

    public static void clearAllRememberedStates() {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        settings.addNewSection(STORE_ID);
    }
}

