/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.chart.ui;

import com.nvidia.viper.chart.IColorDefinitionsManager;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendEntryRenderingHints;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.ExtendedProperty;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.render.ISeriesRenderer;
import org.eclipse.birt.chart.script.ChartEventHandlerAdapter;
import org.eclipse.birt.chart.script.IChartScriptContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractViperChartEventHandler
extends ChartEventHandlerAdapter {
    private static final double MARKER_THREASHOLD = 15.0;
    public static final String PROPERTY_COLOR_BY_SERIES = "viper.color.by.series";
    public static final String PROPERTY_LABELS = "viper.yaxis.labels";
    public static final String PROPERTY_FONT_HEIGHT = "viper.font.height";
    private static Display display = null;
    private static int systemFontHeight = Integer.MIN_VALUE;
    private static int zeroDigitWidth;
    private double accumulatedLabelWidth = 0.0;
    private double accumulatedMarkerWidth = 0.0;
    private Chart birtChart;
    protected final IColorDefinitionsManager colorsManager = this.getColorDefMgr();
    private int series = -2;
    private boolean colorBySeries;
    private String[] dataCaptions;
    private int dataPoint = 0;
    private int fontHeight;
    private int labelWidth = Integer.MIN_VALUE;

    private static double getBlockWidth(IChartScriptContext icsc) {
        Block block = icsc.getChartInstance().getBlock();
        EList children = block.getChildren();
        double width = Double.MAX_VALUE;
        for (Block child : children) {
            if (!child.isPlot()) continue;
            width = child.getBounds().getWidth();
        }
        return width;
    }

    private static int getMaxLabelWidth(EList<MarkerLine> markerLines) {
        int width = 0;
        for (MarkerLine markerLine : markerLines) {
            Label label = markerLine.getLabel();
            if (label == null) continue;
            String value = label.getCaption().getValue();
            width = Math.max(width, value != null ? value.length() : 0);
        }
        return AbstractViperChartEventHandler.getZeroDigitWidth() * (width + 1);
    }

    private static int getZeroDigitWidth() {
        Display current = Display.getCurrent();
        Font font = current.getSystemFont();
        FontData data = font.getFontData()[0];
        if (current != display || systemFontHeight != data.getHeight()) {
            systemFontHeight = data.getHeight();
            display = current;
            GC gc = new GC((Drawable)current);
            Font f = null;
            try {
                data.setHeight(systemFontHeight + -2);
                f = new Font((Device)current, data);
                gc.setFont(f);
                Point extent = gc.textExtent("0");
                zeroDigitWidth = extent.x;
            }
            finally {
                if (f != null) {
                    f.dispose();
                }
                gc.dispose();
            }
        }
        return zeroDigitWidth;
    }

    private static String[] split(String value) {
        return value == null || value.trim().length() == 0 ? new String[]{} : value.split("\\s*\\|\\|\\s*");
    }

    public void beforeDrawAxisLabel(Axis axis, Label label, IChartScriptContext icsc) {
        if (this.dataCaptions != null && !axis.isCategoryAxis()) {
            label.setInsets(InsetsImpl.create((double)(this.fontHeight / 2), (double)0.0, (double)0.0, (double)0.0));
            if (this.dataPoint < this.dataCaptions.length) {
                String dataLabel;
                if ((dataLabel = this.dataCaptions[this.dataPoint++]) == null || dataLabel.trim().length() == 0) {
                    label.setVisible(false);
                } else {
                    label.setVisible(true);
                    label.getCaption().setValue(dataLabel);
                }
            } else {
                label.setVisible(false);
            }
        }
    }

    protected abstract IColorDefinitionsManager getColorDefMgr();

    public void beforeDrawDataPoint(DataPointHints dph, Fill fill, IChartScriptContext icsc) {
        ColorDefinition color;
        if (fill instanceof ColorDefinition && (color = this.colorsManager.getPaletteColor(this.colorBySeries(icsc) ? this.series : dph.getIndex())) != null) {
            ((ColorDefinition)fill).set(color.getRed(), color.getGreen(), color.getBlue());
        }
        super.beforeDrawDataPoint(dph, (Fill)ColorDefinitionImpl.PINK(), icsc);
    }

    public void beforeDrawLegendItem(LegendEntryRenderingHints lerh, Bounds bo, IChartScriptContext icsc) {
        ColorDefinition f;
        Fill fill = lerh.getFill();
        if (fill instanceof ColorDefinition && (f = this.colorsManager.getPaletteColor(lerh.getDataIndex())) != null) {
            ((ColorDefinition)fill).set(f.getRed(), f.getGreen(), f.getBlue());
        }
        super.beforeDrawLegendItem(lerh, bo, icsc);
    }

    public void beforeDrawMarkerLine(Axis axis, MarkerLine mLine, IChartScriptContext icsc) {
        if (axis.isPrimaryAxis()) {
            boolean isLastLine;
            EList markerLines = axis.getMarkerLines();
            if (this.labelWidth < 0) {
                this.labelWidth = AbstractViperChartEventHandler.getMaxLabelWidth((EList<MarkerLine>)markerLines);
            }
            double width = AbstractViperChartEventHandler.getBlockWidth(icsc);
            double markerLineDifference = width / (double)markerLines.size();
            this.accumulatedMarkerWidth += markerLineDifference;
            this.accumulatedLabelWidth += markerLineDifference;
            int indexOf = markerLines.indexOf((Object)mLine);
            boolean bl = isLastLine = indexOf == markerLines.size() - 1;
            if (this.accumulatedMarkerWidth >= 15.0 || isLastLine) {
                mLine.getLineAttributes().setVisible(true);
                if (isLastLine || this.accumulatedLabelWidth >= (double)this.labelWidth && width - markerLineDifference * (double)indexOf > (double)this.labelWidth) {
                    mLine.getLabel().setVisible(true);
                    this.accumulatedLabelWidth = 0.0;
                } else {
                    mLine.getLabel().setVisible(false);
                }
                this.accumulatedMarkerWidth = 0.0;
            } else {
                mLine.getLabel().setVisible(false);
                mLine.getLineAttributes().setVisible(false);
            }
            super.beforeDrawMarkerLine(axis, mLine, icsc);
        }
    }

    public void beforeDrawSeries(Series series, ISeriesRenderer isr, IChartScriptContext icsc) {
        ++this.series;
        super.beforeDrawSeries(series, isr, icsc);
    }

    private synchronized boolean colorBySeries(IChartScriptContext context) {
        if (this.birtChart == null || !this.birtChart.equals(context.getChartInstance())) {
            this.birtChart = context.getChartInstance();
            this.colorBySeries = false;
            EList properties = this.birtChart.getExtendedProperties();
            for (ExtendedProperty extendedProperty : properties) {
                if (PROPERTY_COLOR_BY_SERIES.equals(extendedProperty.getName())) {
                    this.colorBySeries = Boolean.parseBoolean(extendedProperty.getValue());
                    continue;
                }
                if (PROPERTY_LABELS.equals(extendedProperty.getName())) {
                    this.dataCaptions = AbstractViperChartEventHandler.split(extendedProperty.getValue());
                    continue;
                }
                if (!PROPERTY_FONT_HEIGHT.equals(extendedProperty.getName())) continue;
                this.fontHeight = Integer.parseInt(extendedProperty.getValue());
            }
        }
        return this.colorBySeries;
    }
}

