/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.universal.util.Log;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UniversalIntroPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ui.intro.universal";
    private static UniversalIntroPlugin inst;
    private long uiCreationStartTime;
    private ImageRegistry volatileImageRegistry;

    public static UniversalIntroPlugin getDefault() {
        return inst;
    }

    public static IIntroPart getIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        return introPart;
    }

    public static IIntroPart showIntro(boolean standby) {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().showIntro(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), standby);
        return introPart;
    }

    public static boolean isIntroStandby() {
        return PlatformUI.getWorkbench().getIntroManager().isIntroStandby(UniversalIntroPlugin.getIntro());
    }

    public static void setIntroStandby(boolean standby) {
        PlatformUI.getWorkbench().getIntroManager().setIntroStandby(UniversalIntroPlugin.getIntro(), standby);
    }

    public static boolean closeIntro() {
        return PlatformUI.getWorkbench().getIntroManager().closeIntro(UniversalIntroPlugin.getIntro());
    }

    public ImageRegistry getVolatileImageRegistry() {
        if (this.volatileImageRegistry == null) {
            this.volatileImageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.volatileImageRegistry);
        }
        return this.volatileImageRegistry;
    }

    public void resetVolatileImageRegistry() {
        if (this.volatileImageRegistry != null) {
            this.volatileImageRegistry.dispose();
            this.volatileImageRegistry = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        inst = this;
        if (Log.logInfo) {
            Log.info("IntroPlugin - calling start on Intro bundle");
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.resetVolatileImageRegistry();
        super.stop(context);
    }

    public long gettUICreationStartTime() {
        return this.uiCreationStartTime;
    }

    public void setUICreationStartTime(long uiCreationStartTime) {
        this.uiCreationStartTime = uiCreationStartTime;
    }
}

