/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.Cubin;
import com.nvidia.cuda.ide.build.project.CudaExecutable;
import com.nvidia.cuda.ide.build.project.FileNamesComparator;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class CudaProjectConfigurationImpl
implements ICudaProjectConfiguration {
    private static final String ATTR_VERSION_MAJOR = "major";
    private static final String ATTR_VERSION_MINOR = "minor";
    private static final String ELEMENT_EDITOR_ARCH = "editor-arch";
    private static final String ELEMENT_MODULE = "module";
    protected static final String SETTING_INCLUDED_IN_EXE = "nvcc.compiler.isintarget";
    protected static final String SETTING_MODULES = "nvcc.compiler.modules";
    private final ICConfigurationDescription configurationDescription;
    private Collection<IFile> excluded;
    private final AtomicReference<CudaExecutable> executable = new AtomicReference();
    private Map<Integer, Collection<IFile>> filesToModules;
    private final Collection<ICudaProjectConfiguration.IModuleListener> listeners = new HashSet<ICudaProjectConfiguration.IModuleListener>();
    private int nextId;
    private ICStorageElement storage;

    public CudaProjectConfigurationImpl(ICConfigurationDescription configurationDescription) {
        this.configurationDescription = configurationDescription;
    }

    private int addArchitectures(ICudaModule module) {
        return module.getPhysicalArchitectures() | module.getVirtualArchitectures();
    }

    @Override
    public void addModuleListener(ICudaProjectConfiguration.IModuleListener listener) {
        this.listeners.add(listener);
    }

    private void fireModuleAdded(ICubinModule module) {
        for (ICudaProjectConfiguration.IModuleListener listener : this.listeners) {
            try {
                listener.moduleAdded();
            }
            catch (RuntimeException e) {
                Activator.log(e);
            }
        }
    }

    protected final void fireModulePropertyChanged(ICudaModule module, String property) {
        for (ICudaProjectConfiguration.IModuleListener listener : this.listeners) {
            try {
                listener.modulePropertyChanged();
            }
            catch (RuntimeException e) {
                Activator.log(e);
            }
        }
    }

    protected final void fireModuleRemoved(ICubinModule module) {
        for (ICudaProjectConfiguration.IModuleListener listener : this.listeners) {
            try {
                listener.moduleRemoved();
            }
            catch (RuntimeException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public ICConfigurationDescription getConfigurationDescription() {
        return this.configurationDescription;
    }

    @Override
    public Architecture getEditorArchitecture() {
        ICStorageElement[] elements = this.getStorage().getChildrenByName(ELEMENT_EDITOR_ARCH);
        if (elements.length == 1) {
            try {
                return Architecture.get(this.getIntAttribute(elements[0], ATTR_VERSION_MAJOR), this.getIntAttribute(elements[0], ATTR_VERSION_MINOR));
            }
            catch (NumberFormatException e) {
                Activator.log(e);
                return Architecture.get(1, 0);
            }
        }
        int archs = CoreUtil.getLowestSetBit((int)this.getSupportedArchitectures());
        return archs == 0 ? Architecture.get(1, 0) : Architecture.decode(archs)[0];
    }

    protected Collection<IFile> getExcludedFiles() {
        if (this.excluded == null) {
            this.visitFiles(this.configurationDescription);
        }
        return this.excluded;
    }

    private Collection<IFile> getExcludedFiles(final ICConfigurationDescription resDesc) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        TreeSet<ICSourceEntry> set = new TreeSet<ICSourceEntry>(new CompareEntryPathLength());
        final HashSet<IFile> excluded = new HashSet<IFile>();
        set.addAll(Arrays.asList(resDesc.getResolvedSourceEntries()));
        for (final ICSourceEntry src : set) {
            final LanguageManager languageManager = LanguageManager.getInstance();
            IResource resource = root.findMember(src.getFullPath());
            if (!resource.isAccessible()) continue;
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile file;
                    ILanguage language;
                    if (resource.getType() == 1 && (language = languageManager.getLanguageForFile(file = (IFile)resource, resDesc)) != null && "com.nvidia.cuda.ide.editor.cudac".equals(language.getId())) {
                        if (CDataUtil.isExcluded((IPath)resource.getFullPath(), (ICSourceEntry)src)) {
                            excluded.add(file);
                        } else {
                            excluded.remove(resource);
                        }
                    }
                    return true;
                }
            });
        }
        return excluded;
    }

    @Override
    public CudaExecutable getExecutable() {
        if (this.executable.get() == null) {
            this.executable.compareAndSet(null, new CudaExecutable(this, this.getStorage()));
        }
        return this.executable.get();
    }

    private int getIntAttribute(ICStorageElement element, String name) {
        return Integer.parseInt(element.getAttribute(name));
    }

    protected synchronized Collection<IFile> getModuleFiles(int id) {
        Collection<IFile> collection;
        if (this.filesToModules == null) {
            this.visitFiles(this.configurationDescription);
        }
        if ((collection = this.filesToModules.get(id)) == null) {
            collection = new TreeSet<IFile>(new FileNamesComparator());
            this.filesToModules.put(id, collection);
        }
        return collection;
    }

    protected String getModuleId() {
        this.getModules();
        return String.valueOf(++this.nextId);
    }

    public synchronized Cubin[] getModules() {
        ICStorageElement[] elements = this.getStorage().getChildrenByName(ELEMENT_MODULE);
        Cubin[] moduleArray = new Cubin[elements.length];
        int i = 0;
        ICStorageElement[] iCStorageElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement element = iCStorageElementArray[n2];
            Cubin cubin = new Cubin(this, element);
            moduleArray[i++] = cubin;
            this.nextId = Math.max(this.nextId, cubin.getId());
            ++n2;
        }
        Arrays.sort(moduleArray, new ModulePathComparator());
        return moduleArray;
    }

    @Override
    public ICubinModule[] getModules(IFile file) {
        LinkedList<Cubin> modules = new LinkedList<Cubin>();
        Cubin[] cubinArray = this.getModules();
        int n = cubinArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cubin module = cubinArray[n2];
            if (module.includes(file)) {
                modules.add(module);
            }
            ++n2;
        }
        return modules.toArray(new ICubinModule[modules.size()]);
    }

    @Override
    public IProject getProject() {
        return this.configurationDescription.getProjectDescription().getProject();
    }

    private ICStorageElement getStorage() {
        return this.storage;
    }

    @Override
    public int getSupportedArchitectures() {
        int result = this.addArchitectures(this.getExecutable());
        Cubin[] cubinArray = this.getModules();
        int n = cubinArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cubin module = cubinArray[n2];
            result = this.addArchitectures(module);
            ++n2;
        }
        return result;
    }

    private boolean isCudaCFile(IProject project, ICFileDescription description) throws CoreException {
        IPath path;
        LanguageManager languageManager = LanguageManager.getInstance();
        ILanguage language = languageManager.getLanguageForFile(path = description.getPath(), project, description.getConfiguration());
        return language != null && "com.nvidia.cuda.ide.editor.cudac".equals(language.getId());
    }

    public Cubin newModule(IPath path) {
        Cubin module = new Cubin(this, this.getModuleId(), this.getStorage().createChild(ELEMENT_MODULE));
        module.setPath(path);
        this.fireModuleAdded(module);
        return module;
    }

    @Override
    public void reload() throws CoreException {
        this.executable.set(null);
        this.storage = this.configurationDescription.getStorage(ICudaProjectConfiguration.class.getName(), true);
        this.filesToModules = null;
        this.excluded = null;
    }

    @Override
    public void removeModuleListener(ICudaProjectConfiguration.IModuleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void resetToDefault() throws CoreException {
        Cubin[] modules;
        Cubin[] cubinArray = modules = this.getModules();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Cubin module = cubinArray[n2];
            module.remove();
            ++n2;
        }
        this.getExecutable().clearExcludes();
    }

    @Override
    public void setEditorArchitecture(Architecture architecture) {
        ICStorageElement storage = this.getStorage();
        if (architecture == null) {
            ICStorageElement[] iCStorageElementArray = storage.getChildrenByName(ELEMENT_EDITOR_ARCH);
            int n = iCStorageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement element = iCStorageElementArray[n2];
                storage.removeChild(element);
                ++n2;
            }
        } else {
            ICStorageElement element;
            ICStorageElement[] elements = storage.getChildrenByName(ELEMENT_EDITOR_ARCH);
            if (elements.length == 1) {
                element = elements[0];
            } else if (elements.length == 0) {
                element = storage.createChild(ELEMENT_EDITOR_ARCH);
            } else {
                int count = elements.length;
                while (count-- > 1) {
                    storage.removeChild(elements[count - 1]);
                }
                element = elements[0];
            }
            this.setIntAttribute(element, ATTR_VERSION_MAJOR, architecture.major);
            this.setIntAttribute(element, ATTR_VERSION_MINOR, architecture.minor);
        }
    }

    private void setIntAttribute(ICStorageElement element, String attribute, int value) {
        element.setAttribute(attribute, String.valueOf(value));
    }

    private void visitFileIncludedInExe(ICFileDescription description, IFile file) {
        Object value;
        if (Boolean.FALSE.equals(CudaProjectUtil.getCompilerOptionValue((ICResourceDescription)description, SETTING_INCLUDED_IN_EXE))) {
            this.excluded.add(file);
        }
        if ((value = CudaProjectUtil.getCompilerOptionValue((ICResourceDescription)description, SETTING_MODULES)) instanceof Collection) {
            for (String moduleId : (Collection)value) {
                int mid = Integer.parseInt(moduleId);
                Collection<IFile> f = this.filesToModules.get(mid);
                if (f == null) {
                    f = new TreeSet<IFile>(new FileNamesComparator());
                    this.filesToModules.put(mid, f);
                }
                f.add(file);
            }
        }
    }

    private synchronized void visitFiles(ICConfigurationDescription resDesc) {
        try {
            if (this.filesToModules == null) {
                this.excluded = this.getExcludedFiles(resDesc);
                IProject project = this.getProject();
                ICFileDescription[] files = resDesc.getFileDescriptions();
                this.filesToModules = new HashMap<Integer, Collection<IFile>>();
                ICFileDescription[] iCFileDescriptionArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    ICFileDescription description = iCFileDescriptionArray[n2];
                    if (this.isCudaCFile(project, description)) {
                        IFile file = project.getFile(description.getPath());
                        if (description.isExcluded()) {
                            this.excluded.add(file);
                        } else {
                            this.visitFileIncludedInExe(description, file);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public class CompareEntryPathLength
    implements Comparator<ICSourceEntry> {
        @Override
        public int compare(ICSourceEntry o1, ICSourceEntry o2) {
            String p1 = o1.getFullPath().toOSString();
            String p2 = o2.getFullPath().toOSString();
            if (p1.length() > p2.length()) {
                return 1;
            }
            if (p1.length() < p2.length()) {
                return -1;
            }
            return p1.compareTo(p2);
        }
    }

    private static final class ModulePathComparator
    implements Comparator<ICubinModule> {
        private ModulePathComparator() {
        }

        @Override
        public int compare(ICubinModule o1, ICubinModule o2) {
            IPath path1 = o1.getPath();
            IPath path2 = o2.getPath();
            return path1.toPortableString().compareTo(path2.toPortableString());
        }
    }
}

