/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.MultiCubin;
import com.nvidia.cuda.ide.build.project.MultiExecutable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiConfigDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;

public final class MultiConfiguration
implements ICudaProjectConfiguration.IModuleListener {
    private final Collection<String> avaitingEvent = Collections.synchronizedSet(new HashSet());
    private ICConfigurationDescription configurationDescription;
    private CudaProjectConfigurationImpl[] configurations = new CudaProjectConfigurationImpl[0];
    private final Map<ICConfigurationDescription, CudaProjectConfigurationImpl> confs = new HashMap<ICConfigurationDescription, CudaProjectConfigurationImpl>();
    private MultiCubin[] cubins;
    private final MultiExecutable executable = new MultiExecutable(this);
    private final Collection<ICudaProjectConfiguration.IModuleListener> listeners = new HashSet<ICudaProjectConfiguration.IModuleListener>();
    private final AtomicBoolean updating = new AtomicBoolean(false);

    public void addModuleListener(ICudaProjectConfiguration.IModuleListener listener) {
        this.listeners.add(listener);
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            configuration.addModuleListener(listener);
            ++n2;
        }
    }

    @Override
    public void configurationReloaded() {
        this.post(new Runnable(){

            @Override
            public void run() {
                for (ICudaProjectConfiguration.IModuleListener listener : MultiConfiguration.this.listeners) {
                    listener.configurationReloaded();
                }
            }
        }, "reloaded");
    }

    public void fireReloaded() {
        for (ICudaProjectConfiguration.IModuleListener listener : this.listeners) {
            listener.configurationReloaded();
        }
    }

    public ICConfigurationDescription getConfigurationDescription() {
        return this.configurationDescription;
    }

    public Architecture getEditorArchitecture() {
        Architecture architecture = null;
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            Architecture a = configuration.getEditorArchitecture();
            if (architecture == null) {
                if (a == null) {
                    return null;
                }
                architecture = a;
            } else if (!architecture.equals(a)) {
                return null;
            }
            ++n2;
        }
        return architecture;
    }

    public MultiExecutable getExecutable() {
        return this.executable;
    }

    private Collection<IPath> getModulePaths(ICudaProjectConfiguration configuration) {
        ICubinModule[] modules = configuration.getModules();
        HashSet<IPath> paths = new HashSet<IPath>(modules.length);
        ICubinModule[] iCubinModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ICubinModule cubin = iCubinModuleArray[n2];
            paths.add(cubin.getPath());
            ++n2;
        }
        return paths;
    }

    public MultiCubin[] getModules() {
        return this.cubins;
    }

    public final CudaProjectConfigurationImpl[] getNestedConfigurations() {
        return this.configurations;
    }

    public IProject getProject() {
        return this.configurationDescription.getProjectDescription().getProject();
    }

    public int getSupportedArchitectures() {
        int mask = 0;
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            mask |= configuration.getSupportedArchitectures();
            ++n2;
        }
        return mask;
    }

    public void load(ICConfigurationDescription configurationDescription) throws CoreException {
        Collection<ICConfigurationDescription> descriptions;
        this.configurationDescription = configurationDescription;
        if (configurationDescription instanceof ICMultiConfigDescription) {
            Object[] items = ((ICMultiConfigDescription)configurationDescription).getItems();
            descriptions = Arrays.asList((ICConfigurationDescription[])items);
        } else {
            descriptions = Collections.singleton(configurationDescription);
        }
        CudaProjectConfigurationImpl[] newArray = new CudaProjectConfigurationImpl[descriptions.size()];
        int i = 0;
        for (ICConfigurationDescription description : descriptions) {
            CudaProjectConfigurationImpl configuration = this.confs.get(description);
            if (configuration == null) {
                configuration = new CudaProjectConfigurationImpl(description);
                this.confs.put(description, configuration);
            }
            configuration.reload();
            configuration.addModuleListener(this);
            newArray[i++] = configuration;
        }
        this.configurations = newArray;
        this.reloadCubins();
        this.fireReloaded();
    }

    @Override
    public void moduleAdded() {
        this.post(new Runnable(){

            @Override
            public void run() {
                MultiConfiguration.this.reloadCubins();
                for (ICudaProjectConfiguration.IModuleListener listener : MultiConfiguration.this.listeners) {
                    listener.moduleAdded();
                }
            }
        }, "moduleAdded");
    }

    @Override
    public void modulePropertyChanged() {
        if (this.updating.compareAndSet(false, true)) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        MultiConfiguration.this.reloadCubins();
                        for (ICudaProjectConfiguration.IModuleListener listener : MultiConfiguration.this.listeners) {
                            listener.modulePropertyChanged();
                        }
                    }
                    finally {
                        MultiConfiguration.this.updating.set(false);
                    }
                }
            }, "modulePropertyChanged");
        }
    }

    @Override
    public void moduleRemoved() {
        this.post(new Runnable(){

            @Override
            public void run() {
                MultiConfiguration.this.reloadCubins();
                for (ICudaProjectConfiguration.IModuleListener listener : MultiConfiguration.this.listeners) {
                    listener.moduleRemoved();
                }
            }
        }, "moduleRemoved");
    }

    public MultiCubin newModule(IPath path) {
        Object[] objectArray = this.getNestedConfigurations();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = objectArray[n2];
            configuration.newModule(path);
            ++n2;
        }
        this.reloadCubins();
        objectArray = this.cubins;
        n = this.cubins.length;
        n2 = 0;
        while (n2 < n) {
            Object cubin = objectArray[n2];
            if (path.equals((Object)((MultiCubin)cubin).getPath())) {
                return cubin;
            }
            ++n2;
        }
        throw new IllegalStateException(path.toString());
    }

    private void post(final Runnable runnable, final String key) {
        Display display = Display.getDefault();
        if (!this.avaitingEvent.contains(key)) {
            this.avaitingEvent.add(key);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MultiConfiguration.this.avaitingEvent.remove(key);
                    runnable.run();
                }
            });
        }
    }

    public void reload() throws CoreException {
        this.load(this.getConfigurationDescription());
        this.reloadCubins();
    }

    protected synchronized void reloadCubins() {
        HashSet<IPath> paths = new HashSet<IPath>();
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            Collection<IPath> configurationPaths = this.getModulePaths(configuration);
            paths.addAll(configurationPaths);
            ++n2;
        }
        MultiCubin[] newCubins = new MultiCubin[paths.size()];
        int i = 0;
        for (IPath path : paths) {
            MultiCubin c = null;
            if (this.cubins != null) {
                MultiCubin[] multiCubinArray = this.cubins;
                int n3 = this.cubins.length;
                int n4 = 0;
                while (n4 < n3) {
                    MultiCubin cubin = multiCubinArray[n4];
                    if (cubin.getPath().equals((Object)path)) {
                        c = cubin;
                        break;
                    }
                    ++n4;
                }
            }
            if (c == null) {
                c = new MultiCubin(this, path);
            }
            newCubins[i++] = c;
        }
        Arrays.sort(newCubins, new Comparator<MultiCubin>(){

            @Override
            public int compare(MultiCubin o1, MultiCubin o2) {
                return o1.getPath().toString().compareTo(o2.getPath().toString());
            }
        });
        this.cubins = newCubins;
    }

    public void removeModuleListener(ICudaProjectConfiguration.IModuleListener listener) {
        this.listeners.remove(listener);
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            configuration.removeModuleListener(listener);
            ++n2;
        }
    }

    public void resetToDefault() throws CoreException {
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            configuration.resetToDefault();
            ++n2;
        }
    }

    public void setEditorArchitecture(Architecture architecture) {
        CudaProjectConfigurationImpl[] cudaProjectConfigurationImplArray = this.getNestedConfigurations();
        int n = cudaProjectConfigurationImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            CudaProjectConfigurationImpl configuration = cudaProjectConfigurationImplArray[n2];
            configuration.setEditorArchitecture(architecture);
            ++n2;
        }
    }
}

