/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.wizard.samples.HasSamplesValidator;
import com.nvidia.cuda.ide.wizard.samples.ProjectSample;
import com.nvidia.cuda.ide.wizard.samples.SamplesCategory;
import com.nvidia.cuda.ide.wizard.samples.SamplesModel;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SampleSelectionWizardPage
extends WizardPage
implements IWizardDataPage {
    public static final String KEY_SAMPLES_PATH = "sdk.samples";
    private final SamplesModel model;
    private Text installLocation;
    private TableViewer samples;
    private Text description;
    private Label minspec;
    private Combo scope;
    private ComboViewer comboViewer;
    private IWizardPage next;
    private Link whitepaper;

    protected SampleSelectionWizardPage(SamplesModel model) {
        super("CUDA Sample", "Select the CUDA Sample", null);
        this.model = model;
        this.setDescription("Select the CUDA sample to import to your local workspace");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        this.setControl((Control)root);
        root.setLayout((Layout)new GridLayout(3, false));
        Label lblSampleProjectsLocation = new Label(root, 0);
        lblSampleProjectsLocation.setText("Samples install location:");
        this.installLocation = new Text(root, 2048);
        this.installLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button installBrowse = new Button(root, 0);
        installBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SampleSelectionWizardPage.this.browseForSamples();
            }
        });
        installBrowse.setText("Browse...");
        Label label = new Label(root, 256);
        GridData gd_label = new GridData(4, 0x1000000, false, false, 3, 1);
        gd_label.heightHint = 5;
        label.setLayoutData((Object)gd_label);
        SashForm sashForm = new SashForm(root, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        GridLayout gl_composite_1 = new GridLayout(1, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        this.comboViewer = new ComboViewer(composite_1, 8);
        this.comboViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                return element instanceof SamplesCategory ? ((SamplesCategory)element).getWeight() : 100;
            }
        });
        this.scope = this.comboViewer.getCombo();
        this.scope.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.samples = new TableViewer(composite_1, 67584);
        this.samples.setSorter(new ViewerSorter());
        Table table = this.samples.getTable();
        GridData gd_table = new GridData(4, 4, true, true, 1, 1);
        gd_table.heightHint = 100;
        table.setLayoutData((Object)gd_table);
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FormLayout());
        this.description = new Text(composite, 2632);
        this.minspec = new Label(composite, 0);
        this.whitepaper = new Link(composite, 0);
        this.whitepaper.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SampleSelectionWizardPage.this.openWhitepaper(SampleSelectionWizardPage.this.model.getSelectedSample().getWhitepaper());
            }
        });
        FormData linkData = new FormData();
        linkData.bottom = new FormAttachment(100);
        linkData.right = new FormAttachment(100);
        this.whitepaper.setLayoutData((Object)linkData);
        FormData fd_minspec = new FormData();
        fd_minspec.left = new FormAttachment(0);
        fd_minspec.right = new FormAttachment((Control)this.whitepaper, 0);
        fd_minspec.bottom = new FormAttachment(100);
        this.minspec.setLayoutData((Object)fd_minspec);
        FormData fd_description = new FormData();
        fd_description.bottom = new FormAttachment((Control)this.minspec, -5);
        fd_description.top = new FormAttachment(0);
        fd_description.left = new FormAttachment(0);
        fd_description.right = new FormAttachment(100);
        this.description.setLayoutData((Object)fd_description);
        this.whitepaper.setText("<a>Show Whitepaper</a>");
        sashForm.setWeights(new int[]{70, 30});
        this.initDataBindings();
    }

    protected void openWhitepaper(final File paper) {
        if (paper != null && paper.isFile()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Program.launch((String)paper.getAbsolutePath());
                }
            });
        }
    }

    protected void browseForSamples() {
        String newPath;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select folder containing CUDA SDK samples");
        dialog.setText("CUDA SDK Samples");
        String path = this.installLocation.getText();
        if (path != null && path.trim().length() > 0) {
            dialog.setFilterPath(path.trim());
        }
        if ((newPath = dialog.open()) != null) {
            this.installLocation.setText(newPath);
        }
    }

    public Map<String, String> getPageData() {
        Activator.getDefault().getPreferenceStore().setValue(KEY_SAMPLES_PATH, this.model.getPath());
        ProjectSample selectedSample = this.model.getSelectedSample();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sample", selectedSample.getManifestFile().getAbsolutePath());
        map.put("primaryfile", selectedSample.getPrimaryFileRelativePath());
        return map;
    }

    public IWizardPage getNextPage() {
        return this.next;
    }

    public void setNextPage(IWizardPage next) {
        this.next = next;
    }

    private void bindDetailsProperty(DataBindingContext bindingContext, IViewerObservableValue selection, String propertyName, Control control, IConverter toView) {
        IObservableValue model = BeansObservables.observeDetailValue((IObservableValue)selection, (String)propertyName, String.class);
        ISWTObservableValue view = SWTObservables.observeText((Control)control);
        UpdateValueStrategy strategy = null;
        if (toView != null) {
            strategy = new UpdateValueStrategy();
            strategy.setConverter(toView);
        }
        bindingContext.bindValue((IObservableValue)view, model, null, strategy);
    }

    private void initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue installLocationObserveTextObserveWidget = SWTObservables.observeText((Control)this.installLocation, (int)24);
        IObservableValue modelPathObserveValue = BeansObservables.observeValue((Object)this.model, (String)"path");
        UpdateValueStrategy textToModel = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        textToModel.setBeforeSetValidator((IValidator)new HasSamplesValidator(this.model));
        bindingContext.bindValue((IObservableValue)installLocationObserveTextObserveWidget, modelPathObserveValue, textToModel, null);
        ObservableSetContentProvider setContentProvider = new ObservableSetContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)setContentProvider.getKnownElements(), SamplesCategory.class, (String)"label");
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.comboViewer.setContentProvider((IContentProvider)setContentProvider);
        this.comboViewer.setInput((Object)this.model.getCategories());
        IViewerObservableValue comboViewerObserveSingleSelection = ViewersObservables.observeSingleSelection((Viewer)this.comboViewer);
        IObservableValue modelCategoryObserveValue = BeansObservables.observeValue((Object)this.model, (String)"category");
        bindingContext.bindValue((IObservableValue)comboViewerObserveSingleSelection, modelCategoryObserveValue, null, null);
        IObservableSet set = BeansObservables.observeDetailSet((IObservableValue)comboViewerObserveSingleSelection, (String)"samples", ProjectSample.class);
        ViewerSupport.bind((StructuredViewer)this.samples, (IObservableSet)set, (IValueProperty)PojoProperties.value(ProjectSample.class, (String)"name"));
        ISWTObservableValue observeEnabled = SWTObservables.observeEnabled((Control)this.samples.getControl());
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new NegateBooleanConverter());
        bindingContext.bindValue((IObservableValue)observeEnabled, BeansObservables.observeDetailValue((IObservableValue)comboViewerObserveSingleSelection, SamplesCategory.class, (String)"empty", Boolean.class), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), strategy);
        IViewerObservableValue templateSelection = ViewersObservables.observeSinglePostSelection((StructuredViewer)this.samples);
        bindingContext.bindValue((IObservableValue)templateSelection, BeansObservables.observeValue((Object)this.model, (String)"selectedSample"));
        this.bindDetailsProperty(bindingContext, templateSelection, "description", (Control)this.description, null);
        this.bindDetailsProperty(bindingContext, templateSelection, "minspec", (Control)this.minspec, new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                return fromObject == null ? null : String.format("Required hardware: %s", fromObject);
            }
        });
        IObservableValue whitepaperProperty = BeansObservables.observeDetailValue((IObservableValue)templateSelection, (String)"whitepaper", File.class);
        ISWTObservableValue whitepaperLink = SWTObservables.observeVisible((Control)this.whitepaper);
        UpdateValueStrategy linkStrategy = new UpdateValueStrategy();
        linkStrategy.setConverter((IConverter)new HasWhitepaper());
        bindingContext.bindValue((IObservableValue)whitepaperLink, whitepaperProperty, null, linkStrategy);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)bindingContext);
    }

    private final class HasWhitepaper
    implements IConverter {
        private HasWhitepaper() {
        }

        public Object getToType() {
            return Boolean.class;
        }

        public Object getFromType() {
            return File.class;
        }

        public Object convert(Object fromObject) {
            return fromObject != null;
        }
    }

    private static final class NegateBooleanConverter
    implements IConverter {
        private NegateBooleanConverter() {
        }

        public Object getToType() {
            return Boolean.class;
        }

        public Object getFromType() {
            return Boolean.class;
        }

        public Object convert(Object fromObject) {
            return fromObject instanceof Boolean ? Boolean.valueOf((Boolean)fromObject == false) : null;
        }
    }
}

