/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.CommonDragAssistantDescriptor;
import org.eclipse.ui.internal.navigator.extensions.IViewerExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.MenuInsertionPoint;

public class NavigatorViewerDescriptorManager {
    private static final NavigatorViewerDescriptorManager INSTANCE = new NavigatorViewerDescriptorManager();
    private final Map viewerDescriptors = new HashMap();

    public static NavigatorViewerDescriptorManager getInstance() {
        return INSTANCE;
    }

    protected NavigatorViewerDescriptorManager() {
        new NavigatorViewerDescriptorRegistry().readRegistry();
        Iterator it = this.viewerDescriptors.values().iterator();
        while (it.hasNext()) {
            NavigatorViewerDescriptor desc = (NavigatorViewerDescriptor)it.next();
            NavigatorViewerDescriptor parentDesc = (NavigatorViewerDescriptor)this.viewerDescriptors.get(desc.getInheritBindingsFromViewer());
            if (parentDesc == null) continue;
            desc.updateFromParent(parentDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigatorViewerDescriptor getNavigatorViewerDescriptor(String aViewerId) {
        NavigatorViewerDescriptor viewerDescriptor = (NavigatorViewerDescriptor)this.viewerDescriptors.get(aViewerId);
        if (viewerDescriptor != null) {
            return viewerDescriptor;
        }
        Map map = this.viewerDescriptors;
        synchronized (map) {
            viewerDescriptor = (NavigatorViewerDescriptor)this.viewerDescriptors.get(aViewerId);
            if (viewerDescriptor == null) {
                viewerDescriptor = new NavigatorViewerDescriptor(aViewerId);
                this.viewerDescriptors.put(viewerDescriptor.getViewerId(), viewerDescriptor);
            }
        }
        return viewerDescriptor;
    }

    private class NavigatorViewerDescriptorRegistry
    extends RegistryReader
    implements IViewerExtPtConstants {
        protected NavigatorViewerDescriptorRegistry() {
            super(NavigatorPlugin.PLUGIN_ID, "viewer");
        }

        protected boolean readElement(IConfigurationElement element) {
            if ("viewer".equals(element.getName())) {
                String helpContext;
                String viewerId = element.getAttribute("viewerId");
                NavigatorViewerDescriptor descriptor = NavigatorViewerDescriptorManager.this.getNavigatorViewerDescriptor(viewerId);
                String inherit = element.getAttribute("inheritBindingsFromViewer");
                if (inherit != null) {
                    descriptor.setInheritBindingsFromViewer(inherit);
                }
                if ((helpContext = element.getAttribute("helpContext")) != null) {
                    descriptor.setHelpContext(helpContext);
                }
                String attPopupMenuId = element.getAttribute("popupMenuId");
                IConfigurationElement[] tagPopupMenu = element.getChildren("popupMenu");
                if (tagPopupMenu.length == 0 && attPopupMenuId != null) {
                    descriptor.setPopupMenuId(attPopupMenuId);
                } else if (attPopupMenuId != null) {
                    NavigatorPlugin.logError(0, "A popupMenuId attribute and popupMenu element may NOT be concurrently specified. (see " + element.getNamespaceIdentifier() + ")", null);
                } else if (tagPopupMenu.length > 1) {
                    NavigatorPlugin.logError(0, "Only one \"popupMenu\" child of \"viewer\" may be specified. (see " + element.getNamespaceIdentifier() + ")", null);
                } else if (tagPopupMenu.length == 1) {
                    String popupMenuId = tagPopupMenu[0].getAttribute("id");
                    String allowsPlatformContributions = tagPopupMenu[0].getAttribute("allowsPlatformContributions");
                    if (popupMenuId != null) {
                        descriptor.setPopupMenuId(popupMenuId);
                    }
                    if (allowsPlatformContributions != null) {
                        descriptor.setAllowsPlatformContributions(Boolean.valueOf(allowsPlatformContributions));
                    }
                    IConfigurationElement[] insertionPointElements = tagPopupMenu[0].getChildren("insertionPoint");
                    MenuInsertionPoint[] insertionPoints = new MenuInsertionPoint[insertionPointElements.length];
                    int indx = 0;
                    while (indx < insertionPointElements.length) {
                        String name = insertionPointElements[indx].getAttribute("name");
                        String stringAttSeparator = insertionPointElements[indx].getAttribute("separator");
                        boolean isSeparator = stringAttSeparator != null ? Boolean.valueOf(stringAttSeparator) : false;
                        insertionPoints[indx] = new MenuInsertionPoint(name, isSeparator);
                        ++indx;
                    }
                    descriptor.setCustomInsertionPoints(insertionPoints);
                }
                IConfigurationElement[] options = element.getChildren("options");
                if (options.length == 1) {
                    IConfigurationElement[] properties = options[0].getChildren("property");
                    int i = 0;
                    while (i < properties.length) {
                        String name = properties[i].getAttribute("name");
                        if (name != null) {
                            String value = properties[i].getAttribute("value");
                            descriptor.setProperty(name, value);
                        }
                        ++i;
                    }
                } else if (options.length > 1) {
                    NavigatorPlugin.logError(0, "Only one \"options\" child of \"viewer\" may be specified. (see " + element.getNamespaceIdentifier() + ")", null);
                }
                return true;
            }
            if ("viewerContentBinding".equals(element.getName())) {
                String viewerId = element.getAttribute("viewerId");
                NavigatorViewerDescriptor descriptor = NavigatorViewerDescriptorManager.this.getNavigatorViewerDescriptor(viewerId);
                descriptor.consumeContentBinding(element);
                return true;
            }
            if ("viewerActionBinding".equals(element.getName())) {
                String viewerId = element.getAttribute("viewerId");
                NavigatorViewerDescriptor descriptor = NavigatorViewerDescriptorManager.this.getNavigatorViewerDescriptor(viewerId);
                descriptor.consumeActionBinding(element);
                return true;
            }
            if ("dragAssistant".equals(element.getName())) {
                String viewerId = element.getAttribute("viewerId");
                NavigatorViewerDescriptor descriptor = NavigatorViewerDescriptorManager.this.getNavigatorViewerDescriptor(viewerId);
                descriptor.addDragAssistant(new CommonDragAssistantDescriptor(element));
                return true;
            }
            return false;
        }

        public void readRegistry() {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(NavigatorPlugin.PLUGIN_ID, "viewer");
            if (point == null) {
                return;
            }
            super.readRegistry();
        }
    }
}

