/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.aggregation.calculator.BigDecimalCalculator;
import org.eclipse.birt.data.aggregation.calculator.BooleanCalculator;
import org.eclipse.birt.data.aggregation.calculator.DateCalculator;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.calculator.NumberCalculator;
import org.eclipse.birt.data.aggregation.calculator.StringCalculator;

public class CalculatorFactory {
    private CalculatorFactory() {
    }

    public static ICalculator getCalculator(Class<?> clz) {
        if (clz.equals(Boolean.class)) {
            return new BooleanCalculator();
        }
        if (Date.class.isAssignableFrom(clz)) {
            return new DateCalculator();
        }
        if (clz.equals(String.class)) {
            return new StringCalculator();
        }
        if (clz.equals(BigDecimal.class)) {
            return new BigDecimalCalculator();
        }
        return new NumberCalculator();
    }
}

