/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCreateProjectViaWizardWizard;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProjectsCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String path;
        List selectedNodes = this.getSelectedNodes(event);
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        if (!(selectedNodes.get(0) instanceof RepositoryTreeNode)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)selectedNodes.get(0);
        switch (node.getType()) {
            case REPO: 
            case WORKINGDIR: {
                path = node.getRepository().getWorkTree().toString();
                break;
            }
            case FOLDER: {
                path = ((File)((FolderNode)node).getObject()).getPath().toString();
                break;
            }
            default: {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
                return null;
            }
        }
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)new GitCreateProjectViaWizardWizard(node.getRepository(), path)){

            protected IDialogSettings getDialogBoundsSettings() {
                return Activator.getDefault().getDialogSettings();
            }
        };
        dlg.setHelpAvailable(false);
        dlg.open();
        return null;
    }
}

