/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityContext;
import com.nvidia.viper.activity.CuptiActivityDevice;
import com.nvidia.viper.activity.CuptiActivityEnvironment;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityKernel;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMarker;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemcpyP2p;
import com.nvidia.viper.activity.CuptiActivityMemset;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.activity.CuptiActivityOverhead;
import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.CuptiActivitySourceLevelResultBase;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.PThreadActivity;
import com.nvidia.viper.model.ProfileDataModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MultiProcessPDMManager {
    private List<String> pdmNameList = new ArrayList<String>();
    private List<Long> maxCorrIdList = new ArrayList<Long>();
    private Map<String, Map<OriginalContext, NewContext>> pdmContextMap = new HashMap<String, Map<OriginalContext, NewContext>>();
    private Map<String, Map<OriginalStream, NewStream>> pdmStreamMap = new HashMap<String, Map<OriginalStream, NewStream>>();
    private Map<String, Map<OriginalDevice, NewDevice>> pdmDeviceMap = new HashMap<String, Map<OriginalDevice, NewDevice>>();
    PdmIdMap pdmGridIdMap = new PdmIdMap();
    PdmIdMap pdmActivityIdMap = new PdmIdMap();
    private Map<Integer, Integer> nextContextIdMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> nextStreamIdMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> deviceAsciiMap = new HashMap<Integer, Integer>();
    private Map<byte[], Integer> nextDeviceIdMap = new HashMap<byte[], Integer>();
    private long maxCorrId = 0L;
    private int processId = -1;
    private static final int asciiOfchara = 97;
    private long maxDuration = -1L;

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(long maxDuration) {
        this.maxDuration = maxDuration;
    }

    private boolean isDuplicateContextId(int ctxId, int deviceId) {
        for (Map<OriginalContext, NewContext> ctxMap : this.pdmContextMap.values()) {
            for (OriginalContext orgContext : ctxMap.keySet()) {
                if (!orgContext.equals(new OriginalContext(ctxId, deviceId, null, -1))) continue;
                return true;
            }
        }
        return false;
    }

    private int getUniqueContextId(int deviceId) {
        List<Integer> ctsIds = this.getNewContextIds(deviceId);
        if (!this.nextContextIdMap.containsKey(deviceId)) {
            this.nextContextIdMap.put(deviceId, 1);
        }
        int uniqueId = this.nextContextIdMap.get(deviceId);
        while (uniqueId < Integer.MAX_VALUE) {
            if (!ctsIds.contains(uniqueId)) break;
            ++uniqueId;
        }
        int next = this.nextContextIdMap.get(deviceId) + 1;
        this.nextContextIdMap.put(deviceId, next);
        return uniqueId;
    }

    private List<Integer> getNewContextIds(int deviceId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map<OriginalContext, NewContext> deviceCtxMap : this.pdmContextMap.values()) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                if (orgCtx.deviceId != deviceId) continue;
                list.add(entry.getValue().contextId);
            }
        }
        return list;
    }

    private void addContext(CuptiActivityContext context, String pdm) {
        int newId = context.contextId;
        String customName = null;
        if (CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS.equals((Object)context.getComputeKind())) {
            newId = 1;
            customName = "MPS";
        } else if (this.isDuplicateContextId(context.contextId, context.deviceId)) {
            newId = this.getUniqueContextId(context.deviceId);
        }
        Map<Object, Object> deviceCtxMap = this.pdmContextMap.containsKey(pdm) ? this.pdmContextMap.get(pdm) : new HashMap();
        OriginalContext orgCtx = new OriginalContext(context.contextId, context.deviceId, context.getComputeKind(), context.defaultStreamId);
        NewContext newCtx = new NewContext(newId, customName);
        deviceCtxMap.put(orgCtx, newCtx);
        this.pdmContextMap.put(pdm, deviceCtxMap);
    }

    private int getNewDeviceId(int deviceId, String pdm) {
        Map<OriginalDevice, NewDevice> uuidDeviceMap = this.pdmDeviceMap.get(pdm);
        if (uuidDeviceMap != null) {
            for (Map.Entry<OriginalDevice, NewDevice> entry : uuidDeviceMap.entrySet()) {
                OriginalDevice orgDevice = entry.getKey();
                if (orgDevice.deviceId != deviceId) continue;
                return entry.getValue().deviceId;
            }
        }
        return deviceId;
    }

    private List<Integer> getNewDeviceIds(byte[] uuid) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map<OriginalDevice, NewDevice> uuidDeviceMap : this.pdmDeviceMap.values()) {
            for (NewDevice newDevice : uuidDeviceMap.values()) {
                list.add(newDevice.deviceId);
            }
        }
        return list;
    }

    private char addCharacter(int orgDeviceid) {
        if (this.deviceAsciiMap.get(orgDeviceid) != null) {
            int lastascii = this.deviceAsciiMap.get(orgDeviceid);
            this.deviceAsciiMap.put(orgDeviceid, ++lastascii);
            return (char)lastascii;
        }
        this.deviceAsciiMap.put(orgDeviceid, 97);
        return 'a';
    }

    boolean isUuidSame(OriginalDevice orgDevice, byte[] uuid) {
        if (uuid != null) {
            int i = 0;
            while (i < uuid.length) {
                if (orgDevice.uuid[i] != uuid[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private String getDeviceCustomName(int deviceId, byte[] uuid, String pdm) {
        Map<OriginalDevice, NewDevice> uuidDeviceMap = this.pdmDeviceMap.get(pdm);
        if (uuid != null && uuidDeviceMap != null) {
            for (Map.Entry<OriginalDevice, NewDevice> entry : uuidDeviceMap.entrySet()) {
                OriginalDevice orgDevice = entry.getKey();
                if (!orgDevice.equals(new OriginalDevice(deviceId, uuid))) continue;
                return entry.getValue().customName;
            }
        }
        return null;
    }

    private int getUniqueDeviceId(byte[] uuid) {
        List<Integer> deviceIds = this.getNewDeviceIds(uuid);
        if (!this.nextDeviceIdMap.containsKey(uuid)) {
            this.nextDeviceIdMap.put(uuid, 1);
        }
        int uniqueId = this.nextDeviceIdMap.get(uuid);
        while (uniqueId < Integer.MAX_VALUE) {
            if (!deviceIds.contains(uniqueId)) break;
            ++uniqueId;
        }
        int next = this.nextDeviceIdMap.get(uuid) + 1;
        this.nextDeviceIdMap.put(uuid, next);
        return uniqueId;
    }

    private boolean isDuplicateDeviceId(int deviceId, byte[] uuid) {
        for (Map<OriginalDevice, NewDevice> deviceMap : this.pdmDeviceMap.values()) {
            for (Map.Entry<OriginalDevice, NewDevice> entry : deviceMap.entrySet()) {
                OriginalDevice orgDevice = entry.getKey();
                NewDevice newDevice = entry.getValue();
                if (this.isUuidSame(orgDevice, uuid) || newDevice.deviceId != deviceId) continue;
                if (newDevice.customName == null) {
                    newDevice.customName = this.getDeviceCustomName(orgDevice.deviceId);
                }
                return true;
            }
        }
        return false;
    }

    private void addDevice(CuptiActivityDevice device, String pdm) {
        for (Map<OriginalDevice, NewDevice> deviceMap : this.pdmDeviceMap.values()) {
            for (Map.Entry<OriginalDevice, NewDevice> entry : deviceMap.entrySet()) {
                OriginalDevice orgDevice = entry.getKey();
                if (device.id != orgDevice.deviceId || !this.isUuidSame(orgDevice, device.uuid)) continue;
                this.pdmDeviceMap.put(pdm, deviceMap);
                return;
            }
        }
        int newId = device.id;
        String customName = null;
        if (device.uuid != null) {
            if (this.isDuplicateDeviceId(device.id, device.uuid)) {
                customName = this.getDeviceCustomName(device.id);
                newId = this.getUniqueDeviceId(device.uuid);
            }
            Map<Object, Object> uuidDeviceMap = this.pdmDeviceMap.containsKey(pdm) ? this.pdmDeviceMap.get(pdm) : new HashMap();
            OriginalDevice orgDevice = new OriginalDevice(device.id, device.uuid);
            NewDevice newDevice = new NewDevice(newId, customName);
            uuidDeviceMap.put(orgDevice, newDevice);
            this.pdmDeviceMap.put(pdm, uuidDeviceMap);
        }
    }

    private String getDeviceCustomName(int orgDeviceid) {
        return String.valueOf(Integer.toString(orgDeviceid)) + "-" + this.addCharacter(orgDeviceid);
    }

    private void setContextCustomName(String ctxCustomName, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                NewContext newCtx = entry.getValue();
                if (newCtx.customName != null) continue;
                newCtx.customName = String.valueOf(Integer.toString(orgCtx.contextId)) + "-" + ctxCustomName;
            }
        }
    }

    private void setStreamCustomName(String streamCustomName, String pdm) {
        Map<OriginalStream, NewStream> streamMap = this.pdmStreamMap.get(pdm);
        if (streamMap != null) {
            for (Map.Entry<OriginalStream, NewStream> entry : streamMap.entrySet()) {
                OriginalStream orgStream = entry.getKey();
                NewStream newStream = entry.getValue();
                if (newStream.customName != null) continue;
                String name = this.isDefaultStream(orgStream, pdm) ? "Default" : Integer.toString(orgStream.streamId);
                newStream.customName = String.valueOf(name) + "-" + streamCustomName;
            }
        }
    }

    private boolean isDefaultStream(OriginalStream orgStream, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (OriginalContext orgCtx : deviceCtxMap.keySet()) {
                if (orgCtx.contextId != orgStream.contextId || orgCtx.deviceId != orgStream.deviceId) continue;
                if (orgCtx.defaultStreamId == -1 && (orgStream.streamId == 1 || orgStream.streamId == 2)) {
                    return true;
                }
                if (orgCtx.defaultStreamId != orgStream.streamId) continue;
                return true;
            }
        }
        return false;
    }

    private int getNewContextId(int contextId, int deviceId, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                if (!orgCtx.equals(new OriginalContext(contextId, deviceId, null, -1))) continue;
                return entry.getValue().contextId;
            }
        }
        return contextId;
    }

    private String getContextCustomName(int contextId, int deviceId, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                if (!orgCtx.equals(new OriginalContext(contextId, deviceId, null, -1))) continue;
                return entry.getValue().customName;
            }
        }
        return null;
    }

    private String getStreamCustomName(int streamId, int contextId, int deviceId, String pdm) {
        Map<OriginalStream, NewStream> streamMap = this.pdmStreamMap.get(pdm);
        if (streamMap != null) {
            for (Map.Entry<OriginalStream, NewStream> entry : streamMap.entrySet()) {
                OriginalStream orgStream = entry.getKey();
                if (!orgStream.equals(new OriginalStream(deviceId, contextId, streamId))) continue;
                return entry.getValue().customName;
            }
        }
        return null;
    }

    private void setMaxCorrelationId(long maxCorrId, String pdm) {
        if (!this.isCorrelationIdOverflow()) {
            if (this.pdmNameList.size() > 0) {
                maxCorrId += this.maxCorrIdList.get(this.pdmNameList.size() - 1).longValue();
            }
            this.maxCorrIdList.add(maxCorrId);
            this.pdmNameList.add(pdm);
        }
    }

    private boolean isCorrelationIdOverflow() {
        return !this.maxCorrIdList.isEmpty() && this.maxCorrIdList.get(this.maxCorrIdList.size() - 1) > Integer.MAX_VALUE;
    }

    private int getNewCorrelationId(int correlationId, String pdm) {
        int index = this.pdmNameList.indexOf(pdm);
        if (index == 0) {
            return correlationId;
        }
        if (index > 0) {
            long newCorrId = (long)correlationId + this.maxCorrIdList.get(index - 1);
            if (newCorrId > Integer.MAX_VALUE) {
                return 0;
            }
            return (int)newCorrId;
        }
        return 0;
    }

    private void addStream(int streamId, int contextId, int deviceId, String pdm) {
        String customName = null;
        if (!this.isDuplicateStreamEntry(streamId, contextId, deviceId, pdm)) {
            int newId = this.getUniqueStreamId(deviceId);
            Map<Object, Object> streamMap = this.pdmStreamMap.containsKey(pdm) ? this.pdmStreamMap.get(pdm) : new HashMap();
            OriginalStream orgStream = new OriginalStream(deviceId, contextId, streamId);
            if (!this.isMPSContext(contextId, deviceId, pdm)) {
                customName = this.isDefaultStream(orgStream, pdm) ? "Default" : Integer.toString(streamId);
            }
            streamMap.put(orgStream, new NewStream(newId, customName));
            this.pdmStreamMap.put(pdm, streamMap);
        }
    }

    private boolean isDuplicateStreamEntry(int streamId, int contextId, int deviceId, String pdm) {
        if (this.pdmStreamMap.containsKey(pdm)) {
            Map<OriginalStream, NewStream> streamMap = this.pdmStreamMap.get(pdm);
            for (OriginalStream stream : streamMap.keySet()) {
                if (!stream.equals(new OriginalStream(deviceId, contextId, streamId))) continue;
                return true;
            }
        }
        return false;
    }

    private int getUniqueStreamId(int deviceId) {
        List<Integer> streamIds = this.getNewStreamIds();
        if (!this.nextStreamIdMap.containsKey(deviceId)) {
            this.nextStreamIdMap.put(deviceId, 1);
        }
        int uniqueId = this.nextStreamIdMap.get(deviceId);
        while (uniqueId < Integer.MAX_VALUE) {
            if (!streamIds.contains(uniqueId)) break;
            ++uniqueId;
        }
        int next = this.nextStreamIdMap.get(deviceId) + 1;
        this.nextStreamIdMap.put(deviceId, next);
        return uniqueId;
    }

    private List<Integer> getNewStreamIds() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map<OriginalStream, NewStream> streamMap : this.pdmStreamMap.values()) {
            for (NewStream newStream : streamMap.values()) {
                list.add(newStream.streamId);
            }
        }
        return list;
    }

    private int getNewStreamId(int streamId, int contextId, int deviceId, String pdm) {
        Map<OriginalStream, NewStream> streamMap;
        if (this.isMPSContext(contextId, deviceId, pdm) && (streamMap = this.pdmStreamMap.get(pdm)) != null) {
            for (Map.Entry<OriginalStream, NewStream> entry : streamMap.entrySet()) {
                OriginalStream stream = entry.getKey();
                if (!stream.equals(new OriginalStream(deviceId, contextId, streamId))) continue;
                return entry.getValue().streamId;
            }
        }
        return streamId;
    }

    private boolean isMPSContext(int contextId, int deviceId, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (OriginalContext orgCtx : deviceCtxMap.keySet()) {
                if (!orgCtx.equals(new OriginalContext(contextId, deviceId, null, -1))) continue;
                return CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS.equals((Object)orgCtx.computeKind);
            }
        }
        return false;
    }

    public void startPreProcessing(ProfileDataModel pdm) {
        this.maxCorrId = 0L;
        this.processId = -1;
    }

    public void preProcessActivity(ICuptiActivity activity, ProfileDataModel pdm) throws ViperException {
        this.pdmActivityIdMap.addId(activity.getID(), pdm);
        switch (activity.getKind()) {
            case CUPTI_ACTIVITY_KIND_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                this.addStream(kernel.streamId, kernel.contextId, kernel.deviceId, pdm.toString());
                if (kernel.gridId == 0L) break;
                this.pdmGridIdMap.addId(kernel.gridId, pdm);
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMSET: {
                CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                this.addStream(memset.streamId, memset.contextId, memset.deviceId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY: 
            case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                this.addStream(memcpy.streamId, memcpy.contextId, memcpy.deviceId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_DRIVER: 
            case CUPTI_ACTIVITY_KIND_RUNTIME: {
                CuptiActivityAPI api = (CuptiActivityAPI)activity;
                if (this.processId == -1) {
                    this.processId = api.processId;
                }
                if ((long)api.correlationId <= this.maxCorrId) break;
                this.maxCorrId = api.correlationId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_CONTEXT: {
                CuptiActivityContext context = (CuptiActivityContext)activity;
                this.addContext(context, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_DEVICE: {
                CuptiActivityDevice device = (CuptiActivityDevice)activity;
                this.addDevice(device, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
            case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
            case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                CuptiActivityOpenAcc openacc = (CuptiActivityOpenAcc)activity;
                if (this.processId == -1) {
                    this.processId = openacc.cuProcessId;
                }
                for (Integer cId : openacc.correlations) {
                    if ((long)cId.intValue() <= this.maxCorrId) continue;
                    this.maxCorrId = cId.intValue();
                }
                break;
            }
            case CUPTI_ACTIVITY_KIND_PTHREAD: {
                PThreadActivity pthread = (PThreadActivity)activity;
                if (this.processId != -1) break;
                this.processId = pthread.pid;
                break;
            }
        }
    }

    public void finishPreProcessing(ProfileDataModel pdm) {
        String customName = Integer.toString(this.processId);
        this.setContextCustomName(customName, pdm.toString());
        this.setStreamCustomName(customName, pdm.toString());
        this.setMaxCorrelationId(this.maxCorrId, pdm.toString());
    }

    public String processActivity(ICuptiActivity activity, ProfileDataModel pdm) {
        String customName = null;
        activity.setID(this.pdmActivityIdMap.getNewId(activity.getID(), pdm));
        switch (activity.getKind()) {
            case CUPTI_ACTIVITY_KIND_RUNTIME: {
                int newCorrId;
                CuptiActivityAPI runtime = (CuptiActivityAPI)activity;
                runtime.correlationId = newCorrId = this.getNewCorrelationId(runtime.correlationId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_DRIVER: {
                int newCorrId;
                CuptiActivityAPI driver = (CuptiActivityAPI)activity;
                driver.correlationId = newCorrId = this.getNewCorrelationId(driver.correlationId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL: 
            case CUPTI_ACTIVITY_KIND_CDP_KERNEL: {
                CuptiActivityKernel kernel = (CuptiActivityKernel)activity;
                customName = this.getStreamCustomName(kernel.streamId, kernel.contextId, kernel.deviceId, pdm.toString());
                int newCtxId = this.getNewContextId(kernel.contextId, kernel.deviceId, pdm.toString());
                int newCorrId = this.getNewCorrelationId(kernel.correlationId, pdm.toString());
                int newStreamId = this.getNewStreamId(kernel.streamId, kernel.contextId, kernel.deviceId, pdm.toString());
                int newDeviceId = this.getNewDeviceId(kernel.deviceId, pdm.toString());
                if (kernel.gridId != 0L) {
                    long newGridId;
                    kernel.gridId = newGridId = this.pdmGridIdMap.getNewId(kernel.gridId, pdm);
                }
                if (kernel.parentGridId != 0L) {
                    long newParentGridId;
                    kernel.parentGridId = newParentGridId = this.pdmGridIdMap.getNewId(kernel.parentGridId, pdm);
                }
                kernel.correlationId = newCorrId;
                kernel.contextId = newCtxId;
                kernel.streamId = newStreamId;
                kernel.deviceId = newDeviceId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMSET: {
                CuptiActivityMemset memset = (CuptiActivityMemset)activity;
                customName = this.getStreamCustomName(memset.streamId, memset.contextId, memset.deviceId, pdm.toString());
                int newCtxId = this.getNewContextId(memset.contextId, memset.deviceId, pdm.toString());
                int newCorrId = this.getNewCorrelationId(memset.correlationId, pdm.toString());
                int newStreamId = this.getNewStreamId(memset.streamId, memset.contextId, memset.deviceId, pdm.toString());
                int newDeviceId = this.getNewDeviceId(memset.deviceId, pdm.toString());
                memset.contextId = newCtxId;
                memset.correlationId = newCorrId;
                memset.streamId = newStreamId;
                memset.deviceId = newDeviceId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY: {
                CuptiActivityMemcpy memcpy = (CuptiActivityMemcpy)activity;
                customName = this.getStreamCustomName(memcpy.streamId, memcpy.contextId, memcpy.deviceId, pdm.toString());
                int newCtxId = this.getNewContextId(memcpy.contextId, memcpy.deviceId, pdm.toString());
                int newCorrId = this.getNewCorrelationId(memcpy.correlationId, pdm.toString());
                int newStreamId = this.getNewStreamId(memcpy.streamId, memcpy.contextId, memcpy.deviceId, pdm.toString());
                int newDeviceId = this.getNewDeviceId(memcpy.deviceId, pdm.toString());
                memcpy.contextId = newCtxId;
                memcpy.correlationId = newCorrId;
                memcpy.streamId = newStreamId;
                memcpy.deviceId = newDeviceId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MEMCPY2: {
                CuptiActivityMemcpyP2p memcpy2 = (CuptiActivityMemcpyP2p)activity;
                customName = this.getStreamCustomName(memcpy2.streamId, memcpy2.contextId, memcpy2.deviceId, pdm.toString());
                int newCtxId = this.getNewContextId(memcpy2.contextId, memcpy2.deviceId, pdm.toString());
                int newCorrId = this.getNewCorrelationId(memcpy2.correlationId, pdm.toString());
                int newStreamId = this.getNewStreamId(memcpy2.streamId, memcpy2.contextId, memcpy2.deviceId, pdm.toString());
                int newDeviceId = this.getNewDeviceId(memcpy2.deviceId, pdm.toString());
                memcpy2.contextId = newCtxId;
                memcpy2.correlationId = newCorrId;
                memcpy2.streamId = newStreamId;
                memcpy2.deviceId = newDeviceId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_CONTEXT: {
                CuptiActivityContext context = (CuptiActivityContext)activity;
                int defaultStreamId = this.getNewStreamId(context.defaultStreamId, context.contextId, context.deviceId, pdm.toString());
                customName = this.getContextCustomName(context.contextId, context.deviceId, pdm.toString());
                int newCtxId = this.getNewContextId(context.contextId, context.deviceId, pdm.toString());
                int newDeviceId = this.getNewDeviceId(context.deviceId, pdm.toString());
                context.contextId = newCtxId;
                context.defaultStreamId = defaultStreamId;
                context.deviceId = newDeviceId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_DEVICE: {
                int newDeviceId;
                CuptiActivityDevice device = (CuptiActivityDevice)activity;
                customName = this.getDeviceCustomName(device.id, device.uuid, pdm.toString());
                device.id = newDeviceId = this.getNewDeviceId(device.id, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_ENVIRONMENT: {
                int newDeviceId;
                CuptiActivityEnvironment env = (CuptiActivityEnvironment)activity;
                env.deviceId = newDeviceId = this.getNewDeviceId(env.deviceId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_UVM_COUNTER: {
                CuptiActivityUvmCounter uvm = (CuptiActivityUvmCounter)activity;
                ArrayList<Integer> deviceIdList = new ArrayList<Integer>();
                for (int deviceId : uvm.getDeviceIDList()) {
                    int newDeviceId = this.getNewDeviceId(deviceId, pdm.toString());
                    deviceIdList.add(newDeviceId);
                }
                uvm.setDeviceIDList(deviceIdList);
                break;
            }
            case CUPTI_ACTIVITY_KIND_NAME: {
                CuptiActivityName name = (CuptiActivityName)activity;
                if (name.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_DEVICE && name.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_CONTEXT && name.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_STREAM) break;
                int newDeviceId = this.getNewDeviceId(name.objectDeviceId, pdm.toString());
                int newStreamId = this.getNewStreamId(name.objectStreamId, name.objectContextId, name.objectDeviceId, pdm.toString());
                int newCtxId = this.getNewContextId(name.objectContextId, name.objectDeviceId, pdm.toString());
                name.objectDeviceId = newDeviceId;
                name.objectStreamId = newStreamId;
                name.objectContextId = newCtxId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_MARKER: {
                CuptiActivityMarker marker = (CuptiActivityMarker)activity;
                if (marker.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_DEVICE && marker.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_CONTEXT && marker.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_STREAM) break;
                int newDeviceId = this.getNewDeviceId(marker.objectDeviceId, pdm.toString());
                int newStreamId = this.getNewStreamId(marker.objectStreamId, marker.objectContextId, marker.objectDeviceId, pdm.toString());
                int newCtxId = this.getNewContextId(marker.objectContextId, marker.objectDeviceId, pdm.toString());
                marker.objectDeviceId = newDeviceId;
                marker.objectStreamId = newStreamId;
                marker.objectContextId = newCtxId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_OVERHEAD: {
                CuptiActivityOverhead overhead = (CuptiActivityOverhead)activity;
                if (overhead.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_DEVICE && overhead.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_CONTEXT && overhead.getObjectKind() != CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_STREAM) break;
                int newDeviceId = this.getNewDeviceId(overhead.objectDeviceId, pdm.toString());
                int newStreamId = this.getNewStreamId(overhead.objectStreamId, overhead.objectContextId, overhead.objectDeviceId, pdm.toString());
                int newCtxId = this.getNewContextId(overhead.objectContextId, overhead.objectDeviceId, pdm.toString());
                overhead.objectDeviceId = newDeviceId;
                overhead.objectStreamId = newStreamId;
                overhead.objectContextId = newCtxId;
                break;
            }
            case CUPTI_ACTIVITY_KIND_EVENT: 
            case CUPTI_ACTIVITY_KIND_EVENT_INSTANCE: {
                int newCorrId;
                CuptiActivityEvent event = (CuptiActivityEvent)activity;
                event.correlationId = newCorrId = this.getNewCorrelationId(event.correlationId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_METRIC: 
            case CUPTI_ACTIVITY_KIND_METRIC_INSTANCE: {
                int newCorrId;
                CuptiActivityMetric metric = (CuptiActivityMetric)activity;
                metric.correlationId = newCorrId = this.getNewCorrelationId(metric.correlationId, pdm.toString());
                break;
            }
            case CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS: 
            case CUPTI_ACTIVITY_KIND_BRANCH: 
            case CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION: 
            case CUPTI_ACTIVITY_KIND_SHARED_ACCESS: 
            case CUPTI_ACTIVITY_KIND_PC_SAMPLING: {
                CuptiActivityBase sourceLevel = activity.getKind() == CuptiActivityKind.CUPTI_ACTIVITY_KIND_PC_SAMPLING ? (CuptiActivityPCSampling)activity : (CuptiActivitySourceLevelResultBase)activity;
                int newCorrId = this.getNewCorrelationId(sourceLevel.getCorrelationId(), pdm.toString());
                sourceLevel.setCorrelationId(newCorrId);
                break;
            }
            case CUPTI_ACTIVITY_KIND_OPENACC_DATA: 
            case CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH: 
            case CUPTI_ACTIVITY_KIND_OPENACC_OTHER: {
                CuptiActivityOpenAcc openacc = (CuptiActivityOpenAcc)activity;
                HashSet<Integer> newCorrIds = new HashSet<Integer>();
                for (Integer cId : openacc.correlations) {
                    int newCorrId = this.getNewCorrelationId(cId, pdm.toString());
                    newCorrIds.add(new Integer(newCorrId));
                }
                openacc.correlations = newCorrIds;
                break;
            }
        }
        return customName;
    }

    public ProfileDataModel getOriginalPdm(long newActivityId) {
        return this.pdmActivityIdMap.getOriginalPdm(newActivityId);
    }

    public long getOriginalId(long newActivityId) {
        return this.pdmActivityIdMap.getOriginalId(newActivityId);
    }

    private class NewContext {
        private int contextId;
        private String customName;

        public NewContext(int contextId, String customName) {
            this.contextId = contextId;
            this.customName = customName;
        }
    }

    private class NewDevice {
        private int deviceId;
        private String customName;

        public NewDevice(int deviceId, String customName) {
            this.deviceId = deviceId;
            this.customName = customName;
        }
    }

    private class NewStream {
        private int streamId;
        private String customName;

        public NewStream(int streamId, String customName) {
            this.streamId = streamId;
            this.customName = customName;
        }
    }

    private class OriginalContext {
        private int contextId;
        private int deviceId;
        private CuptiActivityComputeApiKind computeKind;
        private int defaultStreamId;

        public OriginalContext(int contextId, int deviceId, CuptiActivityComputeApiKind computeKind, int defaultStreamId) {
            this.contextId = contextId;
            this.deviceId = deviceId;
            this.computeKind = computeKind;
            this.defaultStreamId = defaultStreamId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OriginalContext) {
                OriginalContext ctx = (OriginalContext)obj;
                if (this.contextId == ctx.contextId && this.deviceId == ctx.deviceId) {
                    return true;
                }
            }
            return false;
        }
    }

    private class OriginalDevice {
        private int deviceId;
        private byte[] uuid;

        public OriginalDevice(int deviceId, byte[] uuid) {
            this.deviceId = deviceId;
            this.uuid = uuid;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OriginalDevice) {
                OriginalDevice device = (OriginalDevice)obj;
                if (this.deviceId == device.deviceId && MultiProcessPDMManager.this.isUuidSame(this, device.uuid)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class OriginalStream {
        private int deviceId;
        private int contextId;
        private int streamId;

        public OriginalStream(int deviceId, int contextId, int streamId) {
            this.deviceId = deviceId;
            this.contextId = contextId;
            this.streamId = streamId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OriginalStream) {
                OriginalStream stream = (OriginalStream)obj;
                if (this.deviceId == stream.deviceId && this.contextId == stream.contextId && this.streamId == stream.streamId) {
                    return true;
                }
            }
            return false;
        }
    }

    private class PdmIdMap {
        private Map<ProfileDataModel, Map<Long, Long>> pdmIdMap = new HashMap<ProfileDataModel, Map<Long, Long>>();
        private Map<Long, PdmIdPair> newIdMap = new HashMap<Long, PdmIdPair>();
        private long nextId = 1L;

        private PdmIdMap() {
        }

        public void addId(long id, ProfileDataModel pdm) {
            Map<Object, Object> idMap;
            long newId = this.getUniqueId();
            if (this.pdmIdMap.containsKey(pdm)) {
                idMap = this.pdmIdMap.get(pdm);
            } else {
                idMap = new HashMap();
                this.pdmIdMap.put(pdm, idMap);
            }
            idMap.put(id, newId);
            this.newIdMap.put(newId, new PdmIdPair(pdm, id));
        }

        private long getUniqueId() {
            long result = this.nextId == Long.MAX_VALUE ? -1L : this.nextId;
            ++this.nextId;
            return result;
        }

        public long getNewId(Long id, ProfileDataModel pdm) {
            Map<Long, Long> idMap;
            if (this.pdmIdMap.containsKey(pdm) && (idMap = this.pdmIdMap.get(pdm)).containsKey(id)) {
                return idMap.get(id);
            }
            return id;
        }

        public ProfileDataModel getOriginalPdm(long newId) {
            return this.newIdMap.get((Object)Long.valueOf((long)newId)).pdm;
        }

        public long getOriginalId(long newId) {
            return this.newIdMap.get((Object)Long.valueOf((long)newId)).id;
        }

        private class PdmIdPair {
            public ProfileDataModel pdm;
            public long id;

            PdmIdPair(ProfileDataModel pdm, long id) {
                this.pdm = pdm;
                this.id = id;
            }
        }
    }
}

