/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.XmlUtil;
import com.nvidia.viper.Activator;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.OpenSessionAction;
import com.nvidia.viper.activity.CuptiActivityAttributeKind;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.RemoteFileSystem;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.IProfileMultiProcess;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.ProfileAllProcesses;
import com.nvidia.viper.model.ProfileChildProcesses;
import com.nvidia.viper.model.ProfileCurrentProcess;
import com.nvidia.viper.model.ProfileMPIProcesses;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.Disposable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Executable
extends ModelWithProperties
implements IModel,
ISessionSerializable,
Disposable {
    public static final String PROPERTY_FILENAME = "exec:filename";
    public static final String PROPERTY_WORKINGDIR = "exec:cwd";
    public static final String PROPERTY_ARGS = "exec:args";
    public static final String PROPERTY_ENV = "exec:env";
    public static final String PROPERTY_TIMEOUT = "exec:timeout";
    public static final String PROPERTY_PROFILEONSTART = "exec:profileonstart";
    public static final String PROPERTY_CONCURRENTKERNEL = "exec:concurrentkernel";
    public static final String PROPERTY_APITRACE = "exec:apitrace";
    public static final String PROPERTY_ENVIRONMENTPROFILING = "exec:environmentprofiling";
    public static final String PROPERTY_UVMPROFILING = "exec:uvmprofiling";
    public static final String PROPERTY_ALLOCTRACKING = "exec:allocationsTracking";
    public static final String PROPERTY_OPENACCPROFILING = "exec:openaccprofiling";
    public static final String PROPERTY_THREADTRACKING = "exec:threadtracking";
    public static final String PROPERTY_LAUNCHCONFIGURATIONNAME = "exec:launchconfiguration";
    public static final String PROPERTY_CONNECTIONNAME = "exec:connectionname";
    private static final String PROPERTY_CPUROFILING = null;
    private String filename;
    private String localFilename;
    private IProfileMultiProcess multiProcessProfile;
    private long lastModifiedTimestamp = 0L;
    private String workingDir;
    private String args;
    private Map<String, String> envMap = new HashMap<String, String>();
    private int timeOut = -1;
    private boolean profileOnStart = true;
    private boolean concurrentKernels = true;
    private boolean apiTrace = true;
    private boolean environmentProfiling = false;
    private boolean uvmProfiling = true;
    private boolean allocationsTracking = false;
    private boolean openaccProfiling = true;
    private boolean threadTracking = false;
    private boolean applicationReplay = false;
    private String launchConfigurationName = null;
    private String connectionName = null;
    private boolean isProfileCPU;
    private int cdpBufferSize;
    private int deviceBufferSize;
    private OpenSessionAction.RemoteConnectionArgs remoteArgs = null;
    private String pgExplainFile;
    private FileSystem fileSystem;

    public Executable() {
        this.multiProcessProfile = new ProfileChildProcesses();
        this.isProfileCPU = Viper.isPgiProduct();
        this.pgExplainFile = Viper.isPgiProduct() && Viper.PGI_PGEXPLAIN_LOCATION != null ? Viper.PGI_PGEXPLAIN_LOCATION : "";
        this.setDefaultAdvancedOptions();
    }

    public String getPgExplainFile() {
        return this.pgExplainFile;
    }

    public void setPgExplainFile(String pgExplainFile) {
        this.pgExplainFile = pgExplainFile;
    }

    public void dispose() {
    }

    public Executable(Element el) throws ViperException {
        this();
        this.read(el);
    }

    public boolean isTimestampChanged() throws ConnectionNotFoundException {
        return FileSystem.getFilesystem(this.getConnectionName()).isTimestampChanged(this.getFilename(), this.lastModifiedTimestamp);
    }

    public String getFilename() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getFilename();
        }
        return this.filename;
    }

    private Executable resolveSettings() {
        return Activator.getDefault().getViperWorkbench().resolveExecutableSettings(this);
    }

    public void setFilename(String filename) {
        if (!StringUtils.equals(filename, this.filename)) {
            IPath path = CoreUtil.getFileOnPath((String)filename);
            this.filename = path != null ? path.toOSString() : filename;
            this.firePropertyChange(PROPERTY_FILENAME);
        }
    }

    public String getMultiProcessArg() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (multiProcess != null) {
            return multiProcess.getNvprofOption();
        }
        return "";
    }

    public boolean isProfileAllProcesses() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        return multiProcess instanceof ProfileAllProcesses;
    }

    public String getProgressSubMessage() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (multiProcess instanceof ProfileAllProcesses) {
            return ViperMessages.Timeline_All_Process_Progress_SubMessage;
        }
        return ViperMessages.Timeline_Progress_SubMessage;
    }

    public boolean isMultiProcess() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (multiProcess != null) {
            return multiProcess.getType().isMultiprocess();
        }
        return false;
    }

    public IProfileMultiProcess getMultiProcessProfile() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getMultiProcessProfile();
        }
        return this.multiProcessProfile;
    }

    public int getMultiProcessOrdinal() {
        return this.getMultiProcessType().ordinal();
    }

    public void setMultiProcessProfile(IProfileMultiProcess multiProcess) {
        this.multiProcessProfile = multiProcess;
    }

    public void setMultiProcessProfile(int type) {
        if (type == IProfileMultiProcess.Type.CHILD_PROCESSES.ordinal()) {
            this.multiProcessProfile = new ProfileChildProcesses();
        } else if (type == IProfileMultiProcess.Type.ALL_PROCESSES.ordinal()) {
            this.multiProcessProfile = new ProfileAllProcesses();
        } else if (type == IProfileMultiProcess.Type.CURRENT_PROCESS.ordinal()) {
            this.multiProcessProfile = new ProfileCurrentProcess();
        }
    }

    private IProfileMultiProcess.Type getMultiProcessType() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (multiProcess != null) {
            return multiProcess.getType();
        }
        return IProfileMultiProcess.Type.CURRENT_PROCESS;
    }

    public boolean isMPI() {
        return this.getMultiProcessType().equals((Object)IProfileMultiProcess.Type.MPI);
    }

    public void setMPILauncher(String launcher) {
        if (this.getMultiProcessType().equals((Object)IProfileMultiProcess.Type.MPI)) {
            ((ProfileMPIProcesses)this.multiProcessProfile).setMPILauncher(launcher);
        }
    }

    public String getMPILauncher() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (this.getMultiProcessType().equals((Object)IProfileMultiProcess.Type.MPI)) {
            return ((ProfileMPIProcesses)multiProcess).getMPILauncher();
        }
        return null;
    }

    public void setMPIArg(String mpiArg) {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (this.getMultiProcessType().equals((Object)IProfileMultiProcess.Type.MPI)) {
            ((ProfileMPIProcesses)multiProcess).setMPIArg(mpiArg);
        }
    }

    public String getMPIArg() {
        IProfileMultiProcess multiProcess = this.getMultiProcessProfile();
        if (multiProcess != null && this.getMultiProcessType().equals((Object)IProfileMultiProcess.Type.MPI)) {
            return ((ProfileMPIProcesses)multiProcess).getMPIArg();
        }
        return null;
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void setLastModifiedTimestamp(long lastModifiedTime) {
        this.lastModifiedTimestamp = lastModifiedTime;
    }

    public String getWorkingDir() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getWorkingDir();
        }
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        if (!StringUtils.equals(workingDir, this.workingDir)) {
            this.workingDir = workingDir;
            this.firePropertyChange(PROPERTY_WORKINGDIR);
        }
    }

    public String getArgs() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getArgs();
        }
        return this.args;
    }

    public void setArgs(String args) {
        if (!StringUtils.equals(args, this.args)) {
            this.args = args;
            this.firePropertyChange(PROPERTY_ARGS);
        }
    }

    public Map<String, String> getEnv() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getEnv();
        }
        return Collections.unmodifiableMap(this.envMap);
    }

    public void addEnvVar(String name, String value) {
        String currentValue;
        if (!(name == null || StringUtils.equals(currentValue = this.envMap.get(name), value) && this.envMap.containsKey(name))) {
            this.envMap.put(name, value);
            this.firePropertyChange(PROPERTY_ENV);
        }
    }

    public void removeEnvVar(String name) {
        if (this.envMap.containsKey(name)) {
            this.envMap.remove(name);
            this.firePropertyChange(PROPERTY_ENV);
        }
    }

    public boolean isRunnable() throws ConnectionNotFoundException {
        return FileSystem.getFilesystem(this.getConnectionName()).isRunnable(this.getFilename());
    }

    public void setTimeOut(int timeOut) {
        if (this.timeOut != timeOut) {
            this.timeOut = timeOut;
            this.firePropertyChange(PROPERTY_TIMEOUT);
        }
    }

    public int getTimeOut() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getTimeOut();
        }
        return this.timeOut;
    }

    public void setProfileOnStart(boolean profileOnStart) {
        if (this.profileOnStart != profileOnStart) {
            this.profileOnStart = profileOnStart;
            this.firePropertyChange(PROPERTY_PROFILEONSTART);
        }
    }

    public boolean isProfileOnStart() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isProfileOnStart();
        }
        return this.profileOnStart;
    }

    public void setConcurrentKernel(boolean concurrent) {
        if (this.concurrentKernels != concurrent) {
            this.concurrentKernels = concurrent;
            this.firePropertyChange(PROPERTY_CONCURRENTKERNEL);
        }
    }

    public boolean isConcurrentKernel() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isConcurrentKernel();
        }
        return this.concurrentKernels;
    }

    public void setApiTrace(boolean api) {
        if (this.apiTrace != api) {
            this.apiTrace = api;
            this.firePropertyChange(PROPERTY_APITRACE);
        }
    }

    public boolean isApiTrace() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isApiTrace();
        }
        return this.apiTrace;
    }

    public boolean isEnvironmentProfiling() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isEnvironmentProfiling();
        }
        return this.environmentProfiling;
    }

    public boolean isUvmProfiling() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isUvmProfiling();
        }
        return this.uvmProfiling;
    }

    public boolean isAllocationsTracking() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isAllocationsTracking();
        }
        return this.allocationsTracking;
    }

    public boolean isProfileCPU() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isProfileCPU();
        }
        return this.isProfileCPU;
    }

    public boolean isOpenAccProfiling() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isOpenAccProfiling();
        }
        return this.openaccProfiling;
    }

    public boolean isThreadTracking() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isThreadTracking();
        }
        return this.threadTracking;
    }

    public void setEnvironmentProfiling(boolean environmentProfiling) {
        if (this.environmentProfiling != environmentProfiling) {
            this.environmentProfiling = environmentProfiling;
            this.firePropertyChange(PROPERTY_ENVIRONMENTPROFILING);
        }
    }

    public void setUvmProfiling(boolean uvmProfiling) {
        if (this.uvmProfiling != uvmProfiling) {
            this.uvmProfiling = uvmProfiling;
            this.firePropertyChange(PROPERTY_UVMPROFILING);
        }
    }

    public void setAllocationsTracking(boolean allocationsTracking) {
        if (this.allocationsTracking != allocationsTracking) {
            this.allocationsTracking = allocationsTracking;
            this.firePropertyChange(PROPERTY_ALLOCTRACKING);
        }
    }

    public void setCpuProfiling(boolean cpuProfiling) {
        if (this.isProfileCPU != cpuProfiling) {
            this.isProfileCPU = cpuProfiling;
            this.firePropertyChange(PROPERTY_CPUROFILING);
        }
    }

    public void setOpenAccProfiling(boolean openaccProfiling) {
        if (this.openaccProfiling != openaccProfiling) {
            this.openaccProfiling = openaccProfiling;
            this.firePropertyChange(PROPERTY_OPENACCPROFILING);
        }
    }

    public void setThreadTracking(boolean threadTracking) {
        if (this.threadTracking != threadTracking) {
            this.threadTracking = threadTracking;
            this.firePropertyChange(PROPERTY_THREADTRACKING);
        }
    }

    public void setApplicationReplay(boolean replay) {
        if (this.applicationReplay != replay) {
            this.applicationReplay = replay;
        }
    }

    public boolean isApplicationReplay() {
        return this.applicationReplay;
    }

    public void setCDPBuffersize(int cdpBuffersize) {
        this.cdpBufferSize = cdpBuffersize;
    }

    public int getCDPBuffersize() {
        return this.cdpBufferSize;
    }

    public void setDeviceBuffersize(int deviceBuffersize) {
        this.deviceBufferSize = deviceBuffersize;
    }

    public int getDeviceBuffersize() {
        return this.deviceBufferSize;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        if (launchConfigurationName != this.launchConfigurationName && launchConfigurationName != null && !launchConfigurationName.trim().equals(this.launchConfigurationName)) {
            this.launchConfigurationName = launchConfigurationName;
            this.firePropertyChange(PROPERTY_LAUNCHCONFIGURATIONNAME);
        }
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setConnectionName(String connectionName) {
        if (this.connectionName != connectionName && connectionName != null && !connectionName.trim().equals(this.connectionName)) {
            this.connectionName = connectionName;
            this.firePropertyChange(PROPERTY_CONNECTIONNAME);
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<executable");
            if (this.filename != null) {
                w.write(" file=\"" + XmlUtil.escapeString((String)this.filename) + "\"");
            }
            if (this.lastModifiedTimestamp > 0L) {
                w.write(" timestamp=\"" + this.lastModifiedTimestamp + "\"");
            }
            if (this.workingDir != null) {
                w.write(" cwd=\"" + XmlUtil.escapeString((String)this.workingDir) + "\"");
            }
            if (this.args != null) {
                w.write(" args=\"" + XmlUtil.escapeString((String)this.args) + "\"");
            }
            if (this.launchConfigurationName != null) {
                w.write(" launchConfiguration=\"" + XmlUtil.escapeString((String)this.launchConfigurationName) + "\"");
            }
            if (this.connectionName != null) {
                w.write(" remoteConnectionName=\"" + XmlUtil.escapeString((String)this.connectionName) + "\"");
            }
            if (this.timeOut >= 0) {
                w.write(" timeout=\"" + this.timeOut + "\"");
            }
            w.write(" profileonstart=\"" + this.profileOnStart + "\"");
            w.write(" concurrentkernels=\"" + this.concurrentKernels + "\"");
            w.write(" apitrace=\"" + this.apiTrace + "\"");
            w.write(" environmentprofiling=\"" + this.environmentProfiling + "\"");
            w.write(" uvmprofiling=\"" + this.uvmProfiling + "\"");
            w.write(" cpuprofiling=\"" + this.isProfileCPU + "\"");
            w.write(" allocationsTracking=\"" + this.allocationsTracking + "\"");
            w.write(" openaccprofiling=\"" + this.openaccProfiling + "\"");
            w.write(" threadtracking=\"" + this.threadTracking + "\"");
            w.write(" devicebuffersize=\"" + this.deviceBufferSize + "\"");
            w.write(" cdpbuffersize=\"" + this.cdpBufferSize + "\"");
            w.write(">");
            if (this.envMap != null) {
                w.write("<envs>");
                for (String name : this.envMap.keySet()) {
                    String value = this.envMap.get(name);
                    w.write("<env");
                    w.write(" name=\"" + XmlUtil.escapeString((String)name) + "\"");
                    if (value != null) {
                        w.write(" value=\"" + XmlUtil.escapeString((String)value) + "\"");
                    }
                    w.write("/>");
                }
                w.write("</envs>");
            }
            if (this.multiProcessProfile != null) {
                w.write("<multiProcess");
                w.write(" type=\"" + this.multiProcessProfile.getType().ordinal() + "\"");
                w.write(" rumMPS=\"" + this.multiProcessProfile.isRunMPSServer() + "\"");
                w.write("/>");
            }
            w.write("</executable>\n");
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        String cdpBufferSizeStr;
        String deviceBufferSizeStr;
        String threadTrackingStr;
        String openaccProfilingStr;
        String allocationsTrackingStr;
        String cpuProfilingStr;
        String uvmProfilingStr;
        String environmentProfilingStr;
        String apiTraceStr;
        String concurrentKernelsStr;
        String profileOnStartStr;
        if (!"executable".equals(el.getTagName())) {
            throw new ViperException("expected \"executable\" tag, got " + el.getTagName());
        }
        this.filename = StringUtils.emptyToNull(el.getAttribute("file"));
        String timesStr = StringUtils.emptyToNull(el.getAttribute("timestamp"));
        if (timesStr != null) {
            this.lastModifiedTimestamp = Long.parseLong(timesStr);
        }
        this.workingDir = StringUtils.emptyToNull(el.getAttribute("cwd"));
        this.args = StringUtils.emptyToNull(el.getAttribute("args"));
        this.launchConfigurationName = StringUtils.emptyToNull(el.getAttribute("launchConfiguration"));
        this.connectionName = StringUtils.emptyToNull(el.getAttribute("remoteConnectionName"));
        String timeoutStr = StringUtils.emptyToNull(el.getAttribute("timeout"));
        if (timeoutStr != null) {
            this.timeOut = Integer.parseInt(timeoutStr);
        }
        if ((profileOnStartStr = StringUtils.emptyToNull(el.getAttribute("profileonstart"))) != null) {
            this.profileOnStart = Boolean.parseBoolean(profileOnStartStr);
        }
        if ((concurrentKernelsStr = StringUtils.emptyToNull(el.getAttribute("concurrentkernels"))) != null) {
            this.concurrentKernels = Boolean.parseBoolean(concurrentKernelsStr);
        }
        if ((apiTraceStr = StringUtils.emptyToNull(el.getAttribute("apitrace"))) != null) {
            this.apiTrace = Boolean.parseBoolean(apiTraceStr);
        }
        if ((environmentProfilingStr = StringUtils.emptyToNull(el.getAttribute("environmentprofiling"))) != null) {
            this.environmentProfiling = Boolean.parseBoolean(environmentProfilingStr);
        }
        if ((uvmProfilingStr = StringUtils.emptyToNull(el.getAttribute("uvmprofiling"))) != null) {
            this.uvmProfiling = Boolean.parseBoolean(uvmProfilingStr);
        }
        if ((cpuProfilingStr = StringUtils.emptyToNull(el.getAttribute("cpuprofiling"))) != null) {
            this.isProfileCPU = Boolean.parseBoolean(cpuProfilingStr);
        }
        if ((allocationsTrackingStr = StringUtils.emptyToNull(el.getAttribute("allocationsTracking"))) != null) {
            this.allocationsTracking = Boolean.parseBoolean(allocationsTrackingStr);
        }
        if ((openaccProfilingStr = StringUtils.emptyToNull(el.getAttribute("openaccprofiling"))) != null) {
            this.openaccProfiling = Boolean.parseBoolean(openaccProfilingStr);
        }
        if ((threadTrackingStr = StringUtils.emptyToNull(el.getAttribute("threadtracking"))) != null) {
            this.threadTracking = Boolean.parseBoolean(threadTrackingStr);
        }
        if ((deviceBufferSizeStr = StringUtils.emptyToNull(el.getAttribute("devicebuffersize"))) != null) {
            this.deviceBufferSize = Integer.parseInt(deviceBufferSizeStr);
        }
        if ((cdpBufferSizeStr = StringUtils.emptyToNull(el.getAttribute("cdpbuffersize"))) != null) {
            this.cdpBufferSize = Integer.parseInt(cdpBufferSizeStr);
        }
        NodeList envList = el.getElementsByTagName("env");
        int e = 0;
        while (e < envList.getLength()) {
            Element envElement = (Element)envList.item(e);
            if (!"env".equals(envElement.getTagName())) {
                throw new ViperException("expected \"env\" tag, got " + envElement.getTagName());
            }
            String nameStr = StringUtils.emptyToNull(envElement.getAttribute("name"));
            String valueStr = StringUtils.emptyToNull(envElement.getAttribute("value"));
            if (nameStr != null) {
                this.addEnvVar(nameStr, valueStr);
            }
            ++e;
        }
        NodeList mpsList = el.getElementsByTagName("multiProcess");
        if (mpsList != null && mpsList.getLength() > 0) {
            Element mpsElement = (Element)mpsList.item(0);
            String strType = StringUtils.emptyToNull(mpsElement.getAttribute("type"));
            int type = Integer.parseInt(strType);
            this.setMultiProcessProfile(type);
        }
    }

    public OpenSessionAction.RemoteConnectionArgs getRemoreArgs() {
        return this.remoteArgs;
    }

    public void setRemoteArgs(OpenSessionAction.RemoteConnectionArgs remote) {
        this.remoteArgs = remote;
    }

    public void setDefaultAdvancedOptions() {
        this.cdpBufferSize = CuptiActivityAttributeKind.CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP.getValue(CuptiActivityAttributeKind.ValueUnit.MB);
        this.deviceBufferSize = CuptiActivityAttributeKind.CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE.getValue(CuptiActivityAttributeKind.ValueUnit.MB);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public String getLocalFilename() {
        if (this.fileSystem instanceof RemoteFileSystem) {
            if (this.localFilename != null) {
                return this.localFilename;
            }
            try {
                this.localFilename = ((RemoteFileSystem)this.fileSystem).downloadExecutable(this.filename);
                return this.localFilename;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.filename;
    }
}

