/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperComputeDictionary;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityContext;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;

public class TimelineContext
extends Timeline
implements IModel {
    private CuptiActivityContext activity;
    private long totalKernelExecutionTime;
    private int totalInvocations;
    private double computeUtilization;

    public TimelineContext(CuptiActivityContext activity) {
        super(Integer.toString(activity == null ? 0 : activity.contextId), TimelineKind.CONTEXT);
        this.activity = activity;
        this.totalKernelExecutionTime = -1L;
        this.totalInvocations = -1;
        this.computeUtilization = -1.0;
    }

    public void setActivity(CuptiActivityContext activity) {
        this.activity = activity;
        if (activity != null) {
            this.setName(Integer.toString(activity.contextId));
        }
    }

    @Override
    public String getDisplayName(boolean verbose) {
        return "Context " + super.getDisplayName(verbose) + " (" + ViperComputeDictionary.COMPUTE_TYPE.getLabel(this.getComputeKind()) + ")";
    }

    public int getId() {
        return this.activity.contextId;
    }

    public CuptiActivityComputeApiKind getComputeKind() {
        return this.activity.getComputeKind();
    }

    public int getDefaultStreamId() {
        return this.activity.defaultStreamId;
    }

    public long getTotalKernelExecutionTime() {
        if (this.totalKernelExecutionTime < 0L) {
            Timeline computeTimeline = null;
            for (Timeline child : this.getChildren()) {
                if (!TimelineKind.KERNELS.equals((Object)child.getKind())) continue;
                computeTimeline = child;
                break;
            }
            this.totalKernelExecutionTime = 0L;
            if (computeTimeline != null) {
                for (Timeline child : computeTimeline.getChildren()) {
                    if (!(child instanceof TimelineKernel)) continue;
                    this.totalKernelExecutionTime += ((TimelineKernel)child).getTotalExecutionTime();
                }
            }
        }
        return this.totalKernelExecutionTime;
    }

    public int getTotalKernelInvocationCount() {
        if (this.totalInvocations < 0) {
            Timeline computeTimeline = null;
            for (Timeline child : this.getChildren()) {
                if (!TimelineKind.KERNELS.equals((Object)child.getKind())) continue;
                computeTimeline = child;
                break;
            }
            this.totalInvocations = 0;
            if (computeTimeline != null) {
                for (Timeline child : computeTimeline.getChildren()) {
                    if (!(child instanceof TimelineKernel)) continue;
                    this.totalInvocations += ((TimelineKernel)child).getTotalInvocationCount();
                }
            }
        }
        return this.totalInvocations;
    }

    public double getComputeUtilization() {
        if (this.computeUtilization < 0.0) {
            Timeline computeTimeline = null;
            for (Timeline child : this.getChildren()) {
                if (!TimelineKind.KERNELS.equals((Object)child.getKind())) continue;
                computeTimeline = child;
                break;
            }
            this.computeUtilization = computeTimeline == null ? 0.0 : (double)computeTimeline.getTotalTime() / (double)this.getSession().getDuration();
        }
        return this.computeUtilization;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
            if (this.getCustomName() != null) {
                CuptiActivityName nameActivity = new CuptiActivityName(CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_CONTEXT.getCode(), 0, 0, this.activity.deviceId, this.activity.contextId, 0, this.getCustomName());
                nameActivity.appendToPDM(pdm.getNativeHandle());
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

