/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ui.ViperMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RememberChoiceDialog
extends ViperMessageDialog {
    private String prefKey;
    private static Button doRemember;

    private RememberChoiceDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String prefKey) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.prefKey = prefKey;
    }

    protected Control createCustomArea(Composite parent) {
        doRemember = new Button(parent, 32);
        doRemember.setText(ViperMessages.Remember_Choice_Message);
        doRemember.setSelection(false);
        return doRemember;
    }

    public static boolean openQuestion(String title, String message, String prefKey, boolean defaultToYes) {
        return RememberChoiceDialog.openMessage(title, message, prefKey, defaultToYes, new String[]{"No", "Yes"});
    }

    public static boolean openMessage(String title, String message, String prefKey, boolean defaultToYes, String[] buttons) {
        int idx = defaultToYes ? 1 : 0;
        RememberChoiceDialog dialog = new RememberChoiceDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), title, null, message, 4, buttons, idx, prefKey);
        String savedPref = Activator.getDefault().getPreferenceStore().getString(prefKey);
        if (savedPref.equals("Always")) {
            return true;
        }
        if (savedPref.equals("Never")) {
            return false;
        }
        int returnCode = dialog.open();
        return returnCode == 1;
    }

    public boolean close() {
        if (doRemember.getSelection()) {
            String preference = this.getReturnCode() == 0 ? "Never" : "Always";
            Activator.getDefault().getPreferenceStore().setValue(this.prefKey, preference);
        }
        return super.close();
    }
}

