/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.chart.AbstractOccupancyChart;

public final class GridBoundOccupancyChart
extends AbstractOccupancyChart {
    private final String[] points;
    private final Double[] warpsActual;
    private final Double[] warpsTheoretical;

    public GridBoundOccupancyChart(TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean highlight) throws ViperException {
        super(calculator.getDeviceTimeline().getMaxWarpsPerMultiprocessor(), highlight);
        int threadsPerBlock = kernel.getThreadsPerBlock();
        int maxBlockSize = calculator.getDeviceTimeline().getMaxThreadsPerBlock();
        this.points = new String[maxBlockSize];
        this.warpsActual = new Double[this.points.length];
        this.warpsTheoretical = new Double[this.points.length];
        int k = 0;
        int i = 1;
        while (i <= maxBlockSize) {
            Double warps = calculator.getWarpsPerSMForBlockSize(i).doubleValue();
            this.points[k] = String.valueOf(i);
            this.warpsActual[k] = null;
            this.warpsTheoretical[k++] = warps;
            ++i;
        }
        this.warpsActual[threadsPerBlock - 1] = this.getTheoreticalPlotData()[threadsPerBlock - 1];
    }

    @Override
    protected Double[] getActualPlotData() {
        return this.warpsActual;
    }

    @Override
    protected Double[] getTheoreticalPlotData() {
        return this.warpsTheoretical;
    }

    public String[] getLabels() {
        return this.points;
    }

    public String getTitle() {
        return ViperMessages.Chart_Block_Size_Title;
    }

    @Override
    public String getXAxisTitle() {
        return ViperMessages.Chart_Block_Size_XAxis;
    }

    @Override
    public String getYAxisTitle() {
        return ViperMessages.Chart_Block_Size_YAxis;
    }

    @Override
    public Integer getVerticalLineStep() {
        return 32;
    }

    @Override
    public boolean isZeroBased() {
        return false;
    }
}

