/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.actions.SessionEditorRetargetAction;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.IViperRunnerListener;
import com.nvidia.viper.run.Runner;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

public class PopupRetargetAction
extends SessionEditorRetargetAction
implements IMenuCreator {
    private IViperRunnerListener runnerListener = new IViperRunnerListener(){

        @Override
        public void sessionUnlocked() {
            PopupRetargetAction.this.handleLockChange();
        }

        @Override
        public void sessionLocked() {
            PopupRetargetAction.this.handleLockChange();
        }
    };
    private Menu menu;
    private final IAction[] actions;
    private boolean ignorePrimary = false;

    public PopupRetargetAction(IAction ... actions) {
        this(actions[0].getId(), actions);
    }

    public PopupRetargetAction(String name, IAction ... actions) {
        super(name, actions[0].getText());
        this.actions = actions;
        this.init(this.actions[0]);
    }

    public PopupRetargetAction(String name, boolean ignorePrimary, IAction ... actions) {
        super(name, actions[0].getText());
        this.actions = actions;
        this.init(actions[0]);
        this.ignorePrimary = ignorePrimary;
    }

    private void init(final IAction action) {
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PopupRetargetAction.this.refreshProperties(action);
            }
        });
        this.refreshProperties(action);
        this.setMenuCreator(this);
        Runner.addListener(this.runnerListener);
        this.handleLockChange();
    }

    protected void refreshProperties(IAction action) {
        this.setDescription(action.getDescription());
        this.setImageDescriptor(action.getImageDescriptor());
        this.setText(action.getText());
        this.setToolTipText(action.getToolTipText());
    }

    public void dispose() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
            this.menu = null;
        }
        Runner.removeListener(this.runnerListener);
    }

    private void fill() {
        int i = 0;
        while (i < this.actions.length) {
            if (!this.ignorePrimary || i != 0) {
                new ActionContributionItem(this.actions[i]).fill(this.menu, -1);
            }
            ++i;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.fill();
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        this.fill();
        return this.menu;
    }

    public void run() {
        this.actions[0].run();
    }

    protected void handleLockChange() {
        Set<Session> locked = Runner.getLockedSessions();
        this.setEnabled(locked.isEmpty());
    }

    public void runWithEvent(Event event) {
        if (this.ignorePrimary) {
            ToolItem item = (ToolItem)event.widget;
            if (item != null) {
                Menu m = this.getMenu((Control)item.getParent());
                m.setVisible(true);
            }
        } else {
            this.run();
        }
    }
}

