/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import java.util.HashMap;
import java.util.Map;

public enum CuptiActivityMemcpyKind {
    CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN(0, null, null),
    CUPTI_ACTIVITY_MEMCPY_KIND_HTOD(1, "HtoD", "host to device"),
    CUPTI_ACTIVITY_MEMCPY_KIND_DTOH(2, "DtoH", "device to host"),
    CUPTI_ACTIVITY_MEMCPY_KIND_HTOA(3, "HtoA", "host to array"),
    CUPTI_ACTIVITY_MEMCPY_KIND_ATOH(4, "AtoH", "array to host"),
    CUPTI_ACTIVITY_MEMCPY_KIND_ATOA(5, "AtoA", "array to array"),
    CUPTI_ACTIVITY_MEMCPY_KIND_ATOD(6, "AtoD", "array to device"),
    CUPTI_ACTIVITY_MEMCPY_KIND_DTOA(7, "DtoA", "device to array"),
    CUPTI_ACTIVITY_MEMCPY_KIND_DTOD(8, "DtoD", "device to device"),
    CUPTI_ACTIVITY_MEMCPY_KIND_HTOH(9, "HtoH", "host to host"),
    CUPTI_ACTIVITY_MEMCPY_KIND_PTOP(10, "PtoP", "peer to peer");

    private int code;
    private String csvLabel;
    private String shortName;
    private String longName;
    private static Map<Integer, CuptiActivityMemcpyKind> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiActivityMemcpyKind>();
        CuptiActivityMemcpyKind[] cuptiActivityMemcpyKindArray = CuptiActivityMemcpyKind.values();
        int n = cuptiActivityMemcpyKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityMemcpyKind res = cuptiActivityMemcpyKindArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiActivityMemcpyKind(int code, String csvLabel, String longName) {
        this.code = code;
        this.csvLabel = csvLabel;
        this.shortName = csvLabel != null ? csvLabel : "<unknown>";
        this.longName = longName;
    }

    public int getCode() {
        return this.code;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public static CuptiActivityMemcpyKind decodeCSV(String name) {
        if (name == null || !name.startsWith("memcpy")) {
            return null;
        }
        CuptiActivityMemcpyKind[] cuptiActivityMemcpyKindArray = CuptiActivityMemcpyKind.values();
        int n = cuptiActivityMemcpyKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityMemcpyKind res = cuptiActivityMemcpyKindArray[n2];
            if (res.csvLabel != null && name.contains(res.csvLabel)) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    public static CuptiActivityMemcpyKind valueOf(String string) {
        return Enum.valueOf(CuptiActivityMemcpyKind.class, string);
    }
}

