/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionCombo;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ConnectionControl
extends Composite {
    private RemoteConnectionCombo connectionCombo;

    public ConnectionControl(Composite parent) {
        super(parent, 0);
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(2, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        this.connectionCombo = new RemoteConnectionCombo((Composite)this);
        this.connectionCombo.initConnectionSelection();
        this.connectionCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                IRemoteConnection conn = (IRemoteConnection)selection.getFirstElement();
                if (conn != null) {
                    if (conn.getName().equals("Add connection...")) {
                        ConnectionControl.this.connectionCombo.manage();
                    } else {
                        ConnectionControl.this.connectionCombo.setPreviousSelected(conn);
                    }
                }
            }
        });
        Button newConnectionButton = new Button((Composite)this, 8);
        newConnectionButton.setText("Manage connections...");
        newConnectionButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionControl.this.connectionCombo.manage();
            }
        });
    }

    protected FileSystem getFileSystem() {
        IRemoteConnection connection = this.connectionCombo.getSelection();
        String connectionName = connection == null ? null : connection.getName();
        try {
            return FileSystem.getFilesystem(connectionName);
        }
        catch (ConnectionNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    protected boolean isLocalConnection() {
        FileSystem fileSystem = this.getFileSystem();
        return fileSystem.isLocal();
    }
}

