/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.ResourceFactory;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class FilteredResourcesSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private static final String SHOW_DERIVED = "ShowDerived";
    private ShowDerivedResourcesAction showDerivedResourcesAction;
    private ResourceItemLabelProvider resourceItemLabelProvider;
    private ResourceItemDetailsLabelProvider resourceItemDetailsLabelProvider;
    private WorkingSetFilterActionGroup workingSetFilterActionGroup;
    private CustomWorkingSetFilter workingSetFilter = new CustomWorkingSetFilter();
    private String title;
    private IContainer container;
    private IContainer searchContainer;
    private int typeMask;
    private boolean isDerived;

    public FilteredResourcesSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
        super(shell, multi);
        IWorkbenchPage activePage;
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (activePage = ww.getActivePage()) != null) {
            IResource resource = null;
            IEditorPart activeEditor = activePage.getActiveEditor();
            if (activeEditor != null && activeEditor == activePage.getActivePart()) {
                IEditorInput editorInput = activeEditor.getEditorInput();
                resource = ResourceUtil.getResource(editorInput);
            } else {
                IStructuredSelection structuredSelection;
                ISelection selection = ww.getSelectionService().getSelection();
                if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
                    resource = ResourceUtil.getResource(structuredSelection.getFirstElement());
                }
            }
            if (resource != null) {
                if (!(resource instanceof IContainer)) {
                    resource = resource.getParent();
                }
                this.searchContainer = (IContainer)resource;
            }
        }
        this.container = container;
        this.typeMask = typesMask;
        this.resourceItemLabelProvider = new ResourceItemLabelProvider();
        this.resourceItemDetailsLabelProvider = new ResourceItemDetailsLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.resourceItemLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.resourceItemDetailsLabelProvider);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.open_resource_dialog");
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.length() == 0) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(String.valueOf(this.title) + " - " + text);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(SHOW_DERIVED, this.showDerivedResourcesAction.isChecked());
        XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
        this.workingSetFilterActionGroup.saveState((IMemento)memento);
        this.workingSetFilterActionGroup.dispose();
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)e));
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        boolean showDerived = settings.getBoolean(SHOW_DERIVED);
        this.showDerivedResourcesAction.setChecked(showDerived);
        this.isDerived = showDerived;
        String setting = settings.get(WORKINGS_SET_SETTINGS);
        if (setting != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                this.workingSetFilterActionGroup.restoreState((IMemento)memento);
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)e));
            }
        }
        this.addListFilter(this.workingSetFilter);
        this.applyFilter();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        this.showDerivedResourcesAction = new ShowDerivedResourcesAction();
        menuManager.add((IAction)this.showDerivedResourcesAction);
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
                    if (!(workingSet == null || workingSet.isAggregateWorkingSet() && workingSet.isEmpty())) {
                        FilteredResourcesSelectionDialog.this.workingSetFilter.setWorkingSet(workingSet);
                        FilteredResourcesSelectionDialog.this.setSubtitle(workingSet.getLabel());
                    } else {
                        IWorkbenchPage page;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (workingSet = (page = window.getActivePage()).getAggregateWorkingSet()).isAggregateWorkingSet() && workingSet.isEmpty()) {
                            workingSet = null;
                        }
                        FilteredResourcesSelectionDialog.this.workingSetFilter.setWorkingSet(workingSet);
                        FilteredResourcesSelectionDialog.this.setSubtitle(null);
                    }
                    FilteredResourcesSelectionDialog.this.scheduleRefresh();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
        this.workingSetFilterActionGroup.fillContextMenu(menuManager);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<Object> resultToReturn = new ArrayList<Object>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof IResource) {
                resultToReturn.add(result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray();
    }

    public int open() {
        IWorkspace workspace;
        IStatus result;
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0 && (result = (workspace = ResourcesPlugin.getWorkspace()).validateName(text, 1)).isOK()) {
            this.setInitialPattern(text);
        }
        return super.open();
    }

    public String getElementName(Object item) {
        IResource resource = (IResource)item;
        return resource.getName();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceFilter(this.container, this.searchContainer, this.isDerived, this.typeMask);
    }

    protected void applyFilter() {
        super.applyFilter();
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int s2Dot;
                String n2;
                Collator collator = Collator.getInstance();
                IResource resource1 = (IResource)o1;
                IResource resource2 = (IResource)o2;
                String s1 = resource1.getName();
                String s2 = resource2.getName();
                int s1Dot = s1.lastIndexOf(46);
                String n1 = s1Dot == -1 ? s1 : s1.substring(0, s1Dot);
                int comparability = collator.compare(n1, n2 = (s2Dot = s2.lastIndexOf(46)) == -1 ? s2 : s2.substring(0, s2Dot));
                if (comparability != 0) {
                    return comparability;
                }
                if ((s1Dot != -1 || s2Dot != -1) && (comparability = collator.compare(s1, s2)) != 0) {
                    return comparability;
                }
                if (FilteredResourcesSelectionDialog.this.searchContainer != null) {
                    IContainer c1 = resource1.getParent();
                    IContainer c2 = resource2.getParent();
                    comparability = FilteredResourcesSelectionDialog.this.pathDistance(c1) - FilteredResourcesSelectionDialog.this.pathDistance(c2);
                    if (comparability != 0) {
                        return comparability;
                    }
                }
                IPath p1 = resource1.getFullPath();
                IPath p2 = resource2.getFullPath();
                int c1 = p1.segmentCount() - 1;
                int c2 = p2.segmentCount() - 1;
                int i = 0;
                while (i < c1 && i < c2) {
                    comparability = collator.compare(p1.segment(i), p2.segment(i));
                    if (comparability != 0) {
                        return comparability;
                    }
                    ++i;
                }
                comparability = c1 - c2;
                return comparability;
            }
        };
    }

    private int pathDistance(IContainer item) {
        IPath containerPath = this.searchContainer.getFullPath();
        IPath itemPath = item.getFullPath();
        if (itemPath.equals((Object)containerPath)) {
            return 0;
        }
        int matching = containerPath.matchingFirstSegments(itemPath);
        if (matching == 0) {
            return 0x3FFFFFFF;
        }
        int containerSegmentCount = containerPath.segmentCount();
        if (matching == containerSegmentCount) {
            return itemPath.segmentCount() - matching;
        }
        return 0x1FFFFFFF + containerSegmentCount - matching;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (itemsFilter instanceof ResourceFilter) {
            IResource[] members = this.container.members();
            progressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_searchJob_taskName, members.length);
            ResourceProxyVisitor visitor = new ResourceProxyVisitor(contentProvider, (ResourceFilter)itemsFilter, progressMonitor);
            if (visitor.visit(this.container.createProxy())) {
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member.isAccessible()) {
                        member.accept((IResourceProxyVisitor)visitor, 0);
                    }
                    progressMonitor.worked(1);
                    if (progressMonitor.isCanceled()) break;
                    ++i;
                }
            }
        }
        progressMonitor.done();
    }

    private class CustomWorkingSetFilter
    extends ViewerFilter {
        private ResourceWorkingSetFilter resourceWorkingSetFilter = new ResourceWorkingSetFilter();

        private CustomWorkingSetFilter() {
        }

        public void setWorkingSet(IWorkingSet workingSet) {
            this.resourceWorkingSetFilter.setWorkingSet(workingSet);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.resourceWorkingSetFilter.select(viewer, parentElement, element);
        }
    }

    protected class ResourceFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private boolean showDerived;
        private IContainer filterContainer;
        private SearchPattern containerPattern;
        private SearchPattern relativeContainerPattern;
        SearchPattern namePattern;
        SearchPattern extensionPattern;
        private int filterTypeMask;

        public ResourceFilter(IContainer container, boolean showDerived, int typeMask) {
            super((FilteredItemsSelectionDialog)FilteredResourcesSelectionDialog.this);
            this.showDerived = false;
            this.filterContainer = container;
            this.showDerived = showDerived;
            this.filterTypeMask = typeMask;
        }

        private ResourceFilter(IContainer container, IContainer searchContainer, boolean showDerived, int typeMask) {
            this(container, showDerived, typeMask);
            String filenamePattern;
            String stringPattern = this.getPattern();
            int matchRule = this.getMatchRule();
            int sep = stringPattern.lastIndexOf(47);
            if (sep != -1) {
                boolean isPrefixPattern;
                filenamePattern = stringPattern.substring(sep + 1, stringPattern.length());
                if ("*".equals(filenamePattern)) {
                    filenamePattern = "**";
                }
                if (sep > 0) {
                    if (filenamePattern.length() == 0) {
                        filenamePattern = "**";
                    }
                    String containerPattern = stringPattern.substring(0, sep);
                    if (searchContainer != null) {
                        this.relativeContainerPattern = new SearchPattern(2);
                        this.relativeContainerPattern.setPattern(searchContainer.getFullPath().append(containerPattern).toString());
                    }
                    if (!containerPattern.startsWith("/")) {
                        containerPattern = String.valueOf('/') + containerPattern;
                    }
                    this.containerPattern = new SearchPattern(3);
                    this.containerPattern.setPattern(containerPattern);
                }
                boolean bl = isPrefixPattern = matchRule == 1 || matchRule == 2 && filenamePattern.endsWith("*");
                if (!isPrefixPattern) {
                    filenamePattern = String.valueOf(filenamePattern) + '<';
                } else if (filenamePattern.endsWith("*") && !filenamePattern.equals("**")) {
                    filenamePattern = filenamePattern.substring(0, filenamePattern.length() - 1);
                }
                this.patternMatcher.setPattern(filenamePattern);
                filenamePattern = this.getPattern();
                matchRule = this.getMatchRule();
            } else {
                filenamePattern = stringPattern;
            }
            int lastPatternDot = filenamePattern.lastIndexOf(46);
            if (lastPatternDot != -1 && matchRule != 0) {
                this.namePattern = new SearchPattern();
                this.namePattern.setPattern(filenamePattern.substring(0, lastPatternDot));
                String extensionPatternStr = filenamePattern.substring(lastPatternDot + 1);
                if (matchRule != 128 && matchRule != 1 && !extensionPatternStr.endsWith("*")) {
                    extensionPatternStr = String.valueOf(extensionPatternStr) + '<';
                }
                this.extensionPattern = new SearchPattern();
                this.extensionPattern.setPattern(extensionPatternStr);
            }
        }

        public ResourceFilter() {
            this(filteredResourcesSelectionDialog.container, filteredResourcesSelectionDialog.searchContainer, filteredResourcesSelectionDialog.isDerived, filteredResourcesSelectionDialog.typeMask);
        }

        public boolean isConsistentItem(Object item) {
            if (!(item instanceof IResource)) {
                return false;
            }
            IResource resource = (IResource)item;
            return this.filterContainer.findMember(resource.getFullPath()) != null;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IResource)) {
                return false;
            }
            IResource resource = (IResource)item;
            return (this.filterTypeMask & resource.getType()) != 0 && this.matchName(resource) && (this.showDerived || !resource.isDerived());
        }

        private boolean matchName(IResource resource) {
            String name = resource.getName();
            if (this.nameMatches(name)) {
                if (this.containerPattern != null) {
                    String containerPath = resource.getParent().getFullPath().toString();
                    if (this.containerPattern.matches(containerPath)) {
                        return true;
                    }
                    if (this.relativeContainerPattern != null) {
                        return this.relativeContainerPattern.matches(containerPath);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean nameMatches(String name) {
            int lastDot;
            if (this.namePattern != null && (lastDot = name.lastIndexOf(46)) != -1 && this.namePattern.matches(name.substring(0, lastDot)) && this.extensionPattern.matches(name.substring(lastDot + 1))) {
                return true;
            }
            return this.matches(name);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            if (filter instanceof ResourceFilter) {
                ResourceFilter resourceFilter = (ResourceFilter)filter;
                if (this.showDerived == resourceFilter.showDerived) {
                    if (this.containerPattern == null) {
                        return resourceFilter.containerPattern == null;
                    }
                    if (resourceFilter.containerPattern == null) {
                        return false;
                    }
                    return this.containerPattern.equals(resourceFilter.containerPattern);
                }
            }
            return false;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!super.equalsFilter(iFilter)) {
                return false;
            }
            if (iFilter instanceof ResourceFilter) {
                ResourceFilter resourceFilter = (ResourceFilter)iFilter;
                if (this.showDerived == resourceFilter.showDerived) {
                    if (this.containerPattern == null) {
                        return resourceFilter.containerPattern == null;
                    }
                    if (resourceFilter.containerPattern == null) {
                        return false;
                    }
                    return this.containerPattern.equals(resourceFilter.containerPattern);
                }
            }
            return false;
        }

        public boolean isShowDerived() {
            return this.showDerived;
        }
    }

    private class ResourceItemDetailsLabelProvider
    extends ResourceItemLabelProvider {
        private ResourceItemDetailsLabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IContainer parent = ((IResource)element).getParent();
            return this.provider.getImage((Object)parent);
        }

        @Override
        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IContainer parent = ((IResource)element).getParent();
            if (parent.getType() == 8) {
                return null;
            }
            return parent.getFullPath().makeRelative().toString();
        }

        @Override
        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = ((ResourceItemLabelProvider)this).listeners.getListeners();
            int i = 0;
            while (i < ((ResourceItemLabelProvider)this).listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ResourceItemLabelProvider
    extends LabelProvider
    implements ILabelProviderListener,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ListenerList listeners = new ListenerList();
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        public ResourceItemLabelProvider() {
            this.provider.addListener((ILabelProviderListener)this);
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IResource res = (IResource)element;
            return this.provider.getImage((Object)res);
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IResource res = (IResource)element;
            String str = res.getName();
            if (FilteredResourcesSelectionDialog.this.isDuplicateElement(element)) {
                str = String.valueOf(str) + " - " + res.getParent().getFullPath().makeRelative().toString();
            }
            return str;
        }

        public StyledString getStyledText(Object element) {
            if (!(element instanceof IResource)) {
                return new StyledString(super.getText(element));
            }
            IResource res = (IResource)element;
            StyledString str = new StyledString(res.getName());
            if (FilteredResourcesSelectionDialog.this.isDuplicateElement(element)) {
                str.append(" - ", StyledString.QUALIFIER_STYLER);
                str.append(res.getParent().getFullPath().makeRelative().toString(), StyledString.QUALIFIER_STYLER);
            }
            return str;
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            super.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private FilteredItemsSelectionDialog.AbstractContentProvider proxyContentProvider;
        private ResourceFilter resourceFilter;
        private IProgressMonitor progressMonitor;

        public ResourceProxyVisitor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, ResourceFilter resourceFilter, IProgressMonitor progressMonitor) throws CoreException {
            this.proxyContentProvider = contentProvider;
            this.resourceFilter = resourceFilter;
            this.progressMonitor = progressMonitor;
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.progressMonitor.isCanceled()) {
                return false;
            }
            IResource resource = proxy.requestResource();
            this.proxyContentProvider.add((Object)resource, (FilteredItemsSelectionDialog.ItemsFilter)this.resourceFilter);
            if (resource.getType() == 2 && resource.isDerived() && !this.resourceFilter.isShowDerived()) {
                return false;
            }
            return resource.getType() != 1;
        }
    }

    private class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            ResourceFactory resourceFactory = new ResourceFactory();
            IResource resource = (IResource)resourceFactory.createElement(element);
            return resource;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            IResource resource = (IResource)item;
            ResourceFactory resourceFactory = new ResourceFactory(resource);
            resourceFactory.saveState(element);
        }
    }

    private class ShowDerivedResourcesAction
    extends Action {
        public ShowDerivedResourcesAction() {
            super(IDEWorkbenchMessages.FilteredResourcesSelectionDialog_showDerivedResourcesAction, 2);
        }

        public void run() {
            FilteredResourcesSelectionDialog.this.isDerived = this.isChecked();
            FilteredResourcesSelectionDialog.this.applyFilter();
        }
    }
}

