/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.properties;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.project.BuildUtils;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTarget;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTargetsList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public final class TargetSystemsPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private RemoteTargetsList body;

    protected Control createContents(Composite parent) {
        this.body = new RemoteTargetsList(parent, 0, BuildUtils.isToolkitProject((IProject)this.getProject()));
        this.body.setLocalProjectLocation(this.getProject().getLocation().toOSString());
        this.body.setTargets(this.prepareData());
        new DataBindingContext().bindValue(this.body.getStatus(), (IObservableValue)new StatusObservable());
        return this.body;
    }

    public IProject getProject() {
        return ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
    }

    public boolean performOk() {
        IProject project = this.getProject();
        return this.body.setup(project);
    }

    private Collection<RemoteTarget> prepareData() {
        LinkedList<RemoteTarget> targets = new LinkedList<RemoteTarget>();
        IProject project = this.getProject();
        SyncConfig[] configs = null;
        try {
            if (project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                configs = SyncConfigManager.getConfigs((IProject)project);
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        if (CoreUtil.isNullOrEmpty(configs)) {
            RemoteTarget defaultTarget = RemoteTarget.forConnection(this.body, null, null, project);
            defaultTarget.setProjectLocation(project.getLocation().toOSString());
            targets.add(defaultTarget);
        } else {
            SyncConfig[] syncConfigArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                SyncConfig config = syncConfigArray[n2];
                RemoteTarget target = RemoteTarget.forConfig(project, this.body, config);
                if (target != null) {
                    if (SyncConfigManager.isLocal((SyncConfig)config)) {
                        target.setProjectLocation(project.getLocation().toOSString());
                    }
                    targets.add(target);
                }
                ++n2;
            }
        }
        return targets;
    }

    private void updateStatus(IStatus status) {
        this.setValid(true);
        this.setErrorMessage(null);
        this.setMessage(null);
        if (status != null) {
            switch (status.getSeverity()) {
                case 4: {
                    this.setErrorMessage(status.getMessage());
                    this.setValid(false);
                    break;
                }
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                }
            }
        }
    }

    private final class StatusObservable
    extends AbstractObservableValue {
        private StatusObservable() {
        }

        protected Object doGetValue() {
            throw new UnsupportedOperationException();
        }

        protected void doSetValue(Object value) {
            TargetSystemsPropertyPage.this.updateStatus((IStatus)value);
        }

        public Object getValueType() {
            return IStatus.class;
        }
    }
}

