/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.handlers;

import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.util.CudaPropertiesTester;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.cdt.internal.core.WeakHashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class TogglePinnedStateHandler
extends AbstractHandler
implements IHandler,
IExecutableExtension,
IElementUpdater {
    private boolean isDelete = false;
    private final WeakHashSet<ISelectionProvider> providersWithListeners = new WeakHashSet();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part;
        IWorkbenchSite site = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event);
        if (this.isDelete && !((part = site.getWorkbenchWindow().getActivePage().getActivePart()) instanceof LaunchView)) {
            return false;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        ISelection selection = provider.getSelection();
        CudaPropertiesTester.getPinnableObjects(selection, new DataRequestMonitor<DeviceThread[]>(ImmediateExecutor.getInstance(), null){

            protected void handleSuccess() {
                DeviceThread[] data = (DeviceThread[])this.getData();
                if (data != null) {
                    TogglePinnedStateHandler.this.setPinnedState(data, !TogglePinnedStateHandler.this.isDelete && TogglePinnedStateHandler.this.getNewPinnedState(data));
                }
            }
        });
        return null;
    }

    private boolean getNewPinnedState(DeviceThread[] pinnableObjects) {
        if (pinnableObjects == null) {
            return true;
        }
        DeviceThread[] deviceThreadArray = pinnableObjects;
        int n = pinnableObjects.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceThread object = deviceThreadArray[n2];
            if (!DebugUtil.isPinned(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map map;
        if (data instanceof Map && (map = (Map)data).containsKey("isDelete")) {
            this.isDelete = Boolean.parseBoolean((String)map.get("isDelete"));
        }
    }

    private void setPinnedState(DeviceThread[] pinnableObjects, boolean newPinnedState) {
        DeviceThread[] deviceThreadArray = pinnableObjects;
        int n = pinnableObjects.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceThread element = deviceThreadArray[n2];
            if (newPinnedState) {
                DebugUtil.pin(element);
            } else {
                DebugUtil.unpin(element);
            }
            ++n2;
        }
    }

    public void updateElement(final UIElement element, Map parameters) {
        String label;
        if (this.isDelete) {
            return;
        }
        final IWorkbenchPartSite site = (IWorkbenchPartSite)element.getServiceLocator().getService(IWorkbenchPartSite.class);
        if (site != null) {
            ISelectionProvider provider = site.getSelectionProvider();
            if (provider != null) {
                if (!this.providersWithListeners.contains((Object)provider)) {
                    this.providersWithListeners.add((Object)provider);
                    provider.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            ICommandService service = (ICommandService)site.getService(ICommandService.class);
                            service.refreshElements("com.nvidia.cuda.ide.debug.commands.pin", null);
                        }
                    });
                }
                Executor executor = Display.getCurrent() != null ? DisplayDsfExecutor.getDisplayDsfExecutor((Display)Display.getCurrent()) : ImmediateExecutor.getInstance();
                CudaPropertiesTester.getPinnableObjects(provider.getSelection(), new DataRequestMonitor<DeviceThread[]>(executor, null){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleSuccess() {
                        boolean newState = TogglePinnedStateHandler.this.getNewPinnedState((DeviceThread[])this.getData());
                        element.setText(newState ? "Pin" : "Unpin");
                    }
                });
                return;
            }
            label = "Pin";
        } else {
            label = "Pin";
        }
        element.setText(label);
    }
}

