/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaRange;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CudaDim
implements Serializable {
    private static final Pattern PARSER = Pattern.compile("\\(?(\\d*)\\s*(,\\s*(\\d*)\\s*(,\\s*(\\d+))?)?\\s*\\)?");
    private static final long serialVersionUID = 4043163873617918293L;
    private final int x;
    private final int y;
    private final int z;

    public static final CudaDim parse(String string) {
        Matcher matcher = PARSER.matcher(string);
        if (matcher.matches()) {
            int x = Integer.parseInt(matcher.group(1));
            if (matcher.groupCount() > 2) {
                int y = Integer.parseInt(matcher.group(3));
                if (matcher.groupCount() > 4) {
                    int z = Integer.parseInt(matcher.group(5));
                    return new CudaDim(x, y, z);
                }
                return new CudaDim(x, y);
            }
            return new CudaDim(x);
        }
        throw new IllegalArgumentException(String.format("%s is not a CUDA dimenstion", string));
    }

    public CudaDim(int x) {
        this(x, 1, 1);
    }

    public CudaDim(int x, int y) {
        this(x, y, 1);
    }

    public CudaDim(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CudaRange allThreads() {
        return new CudaRange(CudaCoord.ZERO, this.lastCoord());
    }

    public boolean contains(CudaCoord coord) {
        return coord.getX() < this.x && coord.getY() < this.y && coord.getZ() < this.z;
    }

    public int elementCount() {
        return this.x * this.y * this.z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CudaDim other = (CudaDim)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public CudaCoord getCoord(long ordinal) {
        int coordX = (int)(ordinal % (long)this.x);
        int coordY = (int)(ordinal / (long)this.x % (long)this.y);
        int coordZ = (int)(ordinal / (long)(this.x * this.y));
        CudaCoord cudaCoord = new CudaCoord(coordX, coordY, coordZ);
        return cudaCoord;
    }

    public long getCount(CudaRange range) {
        return this.getOrdinal(range.getEnd()) - this.getOrdinal(range.getStart()) + 1L;
    }

    public long getOrdinal(CudaCoord coord) {
        return (coord.getZ() * this.y + coord.getY()) * this.x + coord.getX();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public CudaCoord lastCoord() {
        return new CudaCoord(this.x - 1, this.y - 1, this.z - 1);
    }

    public String toString() {
        return String.format("(%d,%d,%d)", this.x, this.y, this.z);
    }
}

