/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IRegion;

public class Region
implements IRegion {
    protected ArrayList<ICElement> fRootElements = new ArrayList(1);

    @Override
    public void add(ICElement element) {
        if (!this.contains(element)) {
            this.removeAllChildren(element);
            this.fRootElements.add(element);
            this.fRootElements.trimToSize();
        }
    }

    @Override
    public boolean contains(ICElement element) {
        int size = this.fRootElements.size();
        ArrayList<ICElement> parents = this.getAncestors(element);
        int i = 0;
        while (i < size) {
            ICElement aTop = this.fRootElements.get(i);
            if (aTop.equals(element)) {
                return true;
            }
            int j = 0;
            int pSize = parents.size();
            while (j < pSize) {
                if (aTop.equals(parents.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private ArrayList<ICElement> getAncestors(ICElement element) {
        ArrayList<ICElement> parents = new ArrayList<ICElement>();
        ICElement parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    @Override
    public ICElement[] getElements() {
        int size = this.fRootElements.size();
        ICElement[] roots = new ICElement[size];
        int i = 0;
        while (i < size) {
            roots[i] = this.fRootElements.get(i);
            ++i;
        }
        return roots;
    }

    @Override
    public boolean remove(ICElement element) {
        this.removeAllChildren(element);
        return this.fRootElements.remove(element);
    }

    private void removeAllChildren(ICElement element) {
        if (element instanceof IParent) {
            ArrayList<ICElement> newRootElements = new ArrayList<ICElement>();
            int i = 0;
            int size = this.fRootElements.size();
            while (i < size) {
                ICElement currentRoot = this.fRootElements.get(i);
                ICElement parent = currentRoot.getParent();
                boolean isChild = false;
                while (parent != null) {
                    if (parent.equals(element)) {
                        isChild = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!isChild) {
                    newRootElements.add(currentRoot);
                }
                ++i;
            }
            this.fRootElements = newRootElements;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        ICElement[] roots = this.getElements();
        buffer.append('[');
        int i = 0;
        while (i < roots.length) {
            buffer.append(roots[i].getElementName());
            if (i < roots.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

