/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.core.runtime.CoreException;

class PDOMClassUtil {
    PDOMClassUtil() {
    }

    static class ConstructorCollector
    implements IPDOMVisitor {
        private final List<ICPPConstructor> fConstructors = new ArrayList<ICPPConstructor>();

        ConstructorCollector() {
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            ICPPConstructor cons;
            if (node instanceof ICPPConstructor && IndexFilter.ALL_DECLARED_OR_IMPLICIT.acceptBinding(cons = (ICPPConstructor)((Object)node))) {
                ICPPClassType owner;
                if (cons instanceof ICPPTemplateInstance && ((owner = cons.getClassOwner()) == null || owner.equals(((ICPPTemplateInstance)((Object)cons)).getSpecializedBinding().getOwner()))) {
                    return false;
                }
                this.fConstructors.add(cons);
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPConstructor[] getConstructors() {
            return this.fConstructors.toArray(new ICPPConstructor[this.fConstructors.size()]);
        }
    }

    static class FieldCollector
    implements IPDOMVisitor {
        private final List<ICPPField> fields = new ArrayList<ICPPField>();

        FieldCollector() {
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            ICPPField field;
            if (node instanceof ICPPField && IndexFilter.ALL_DECLARED_OR_IMPLICIT.acceptBinding(field = (ICPPField)((Object)node))) {
                this.fields.add(field);
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPField[] getFields() {
            return this.fields.toArray(new ICPPField[this.fields.size()]);
        }
    }

    static class MethodCollector
    implements IPDOMVisitor {
        private final List<ICPPMethod> methods = new ArrayList<ICPPMethod>();
        private final boolean acceptNonImplicit;
        private final IndexFilter filter;

        public MethodCollector(boolean acceptImplicit) {
            this(acceptImplicit, true);
        }

        public MethodCollector(boolean acceptImplicit, boolean acceptNonImplicit) {
            this.acceptNonImplicit = acceptNonImplicit;
            this.filter = acceptImplicit ? IndexFilter.ALL_DECLARED_OR_IMPLICIT : IndexFilter.ALL_DECLARED;
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            ICPPMethod method;
            if (node instanceof ICPPMethod && this.filter.acceptBinding(method = (ICPPMethod)((Object)node)) && (this.acceptNonImplicit || method.isImplicit())) {
                this.methods.add(method);
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPMethod[] getMethods() {
            return this.methods.toArray(new ICPPMethod[this.methods.size()]);
        }
    }

    static class NestedClassCollector
    implements IPDOMVisitor {
        private final List<IPDOMNode> nestedClasses = new ArrayList<IPDOMNode>();

        NestedClassCollector() {
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPClassType && !(node instanceof ICPPDeferredClassInstance)) {
                this.nestedClasses.add(node);
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPClassType[] getNestedClasses() {
            return this.nestedClasses.toArray(new ICPPClassType[this.nestedClasses.size()]);
        }
    }
}

