/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rse.services.AbstractService;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;

public abstract class AbstractFileService
extends AbstractService
implements IFileService {
    protected IProgressMonitor progressTick(IProgressMonitor monitor) throws SystemMessageException {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        return new SubProgressMonitor(monitor, 1);
    }

    protected abstract IHostFile[] internalFetch(String var1, String var2, int var3, IProgressMonitor var4) throws SystemMessageException;

    public void getFileMultiple(String[] remoteParents, String[] names, List hostFiles, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null) {
            monitor.beginTask("", remoteParents.length);
        }
        int i = 0;
        while (i < remoteParents.length) {
            IProgressMonitor subMonitor = this.progressTick(monitor);
            hostFiles.add(this.getFile(remoteParents[i], names[i], subMonitor));
            subMonitor.done();
            ++i;
        }
    }

    public IHostFile[] list(String remoteParent, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        return this.internalFetch(remoteParent, fileFilter, fileType, monitor);
    }

    public void listMultiple(String[] remoteParents, String[] fileFilters, int[] fileTypes, List hostFiles, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null) {
            monitor.beginTask("", remoteParents.length);
        }
        int i = 0;
        while (i < remoteParents.length) {
            IProgressMonitor subMonitor = this.progressTick(monitor);
            IHostFile[] result = this.list(remoteParents[i], fileFilters[i], fileTypes[i], subMonitor);
            int j = 0;
            while (j < result.length) {
                hostFiles.add(result[j]);
                ++j;
            }
            subMonitor.done();
            ++i;
        }
    }

    public void listMultiple(String[] remoteParents, String[] fileFilters, int fileType, List hostFiles, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null) {
            monitor.beginTask("", remoteParents.length);
        }
        int i = 0;
        while (i < remoteParents.length) {
            IProgressMonitor subMonitor = this.progressTick(monitor);
            IHostFile[] result = this.list(remoteParents[i], fileFilters[i], fileType, subMonitor);
            int j = 0;
            while (j < result.length) {
                hostFiles.add(result[j]);
                ++j;
            }
            subMonitor.done();
            ++i;
        }
    }

    protected boolean isRightType(int fileType, IHostFile node) {
        switch (fileType) {
            case 0: {
                return true;
            }
            case 1: {
                return node.isFile();
            }
            case 2: {
                return node.isDirectory();
            }
        }
        return true;
    }

    public void deleteBatch(String[] remoteParents, String[] fileNames, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null) {
            monitor.beginTask("", remoteParents.length);
        }
        int i = 0;
        while (i < remoteParents.length) {
            IProgressMonitor subMonitor = this.progressTick(monitor);
            this.delete(remoteParents[i], fileNames[i], subMonitor);
            subMonitor.done();
            ++i;
        }
    }

    public void downloadMultiple(String[] remoteParents, String[] remoteFiles, File[] localFiles, boolean[] isBinaries, String[] hostEncodings, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null) {
            monitor.beginTask("", remoteParents.length);
        }
        int i = 0;
        while (i < remoteParents.length) {
            IProgressMonitor subMonitor = this.progressTick(monitor);
            String remoteParent = remoteParents[i];
            String remoteFile = remoteFiles[i];
            File localFile = localFiles[i];
            boolean isBinary = isBinaries[i];
            String hostEncoding = hostEncodings[i];
            this.download(remoteParent, remoteFile, localFile, isBinary, hostEncoding, subMonitor);
            subMonitor.done();
            ++i;
        }
    }

    public void uploadMultiple(File[] localFiles, String[] remoteParents, String[] remoteFiles, boolean[] isBinaries, String[] srcEncodings, String[] hostEncodings, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null) {
            monitor.beginTask("", remoteParents.length);
        }
        int i = 0;
        while (i < localFiles.length) {
            IProgressMonitor subMonitor = this.progressTick(monitor);
            File localFile = localFiles[i];
            String remoteParent = remoteParents[i];
            String remoteFile = remoteFiles[i];
            boolean isBinary = isBinaries[i];
            String srcEncoding = srcEncodings[i];
            String hostEncoding = hostEncodings[i];
            this.upload(localFile, remoteParent, remoteFile, isBinary, srcEncoding, hostEncoding, subMonitor);
            monitor.done();
            ++i;
        }
    }

    public String getEncoding(IProgressMonitor monitor) throws SystemMessageException {
        return SystemEncodingUtil.getInstance().getLocalDefaultEncoding();
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return null;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return null;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        if ((options & 1) == 0) {
            boolean isBinary = (options & 2) == 0;
            return this.getOutputStream(remoteParent, remoteFile, isBinary, monitor);
        }
        return null;
    }

    public boolean supportsEncodingConversion() {
        return false;
    }
}

