/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.language;

public enum SMVersion {
    sm10("100", SMVersion.getSM10Macros()),
    sm11("110", SMVersion.getSM11Macros()),
    sm12("120", SMVersion.getSM12Macros()),
    sm13("130", SMVersion.getSM13Macros()),
    sm20("200", SMVersion.getSM20Macros()),
    sm21("200", SMVersion.getSM20Macros()),
    sm30("300", SMVersion.getSM20Macros()),
    sm35("350", SMVersion.getSM20Macros());

    private static SMVersion current;
    private static final String[][] VERSION_AGNOSTIC;
    private final String arch;
    private final String[] macros;

    static {
        VERSION_AGNOSTIC = new String[][]{{"UINT_MAX", "0"}, {"threadIdx", "__device__ threadIdx"}, {"blockIdx", "__device__ blockIdx"}, {"blockDim", "__device__ blockDim"}, {"gridDim", "__device__ gridDim"}, {"__GNUC__", "1"}, {"__CUDACC__", ""}, {"__CUDABE__", ""}, {"__THROW", ""}, {"__cplusplus", ""}};
    }

    public static SMVersion getCurrent() {
        return current;
    }

    private static String[] getSM10Macros() {
        return new String[]{"CUDA_FLOAT_MATH_FUNCTIONS", "CUDA_NO_SM_11_ATOMIC_INTRINSICS", "CUDA_NO_SM_12_ATOMIC_INTRINSICS", "CUDA_NO_SM_13_DOUBLE_INTRINSICS"};
    }

    private static String[] getSM11Macros() {
        return new String[]{"CUDA_FLOAT_MATH_FUNCTIONS", "CUDA_NO_SM_12_ATOMIC_INTRINSICS", "CUDA_NO_SM_13_DOUBLE_INTRINSICS"};
    }

    private static String[] getSM12Macros() {
        return new String[]{"CUDA_FLOAT_MATH_FUNCTIONS", "CUDA_NO_SM_13_DOUBLE_INTRINSICS"};
    }

    private static String[] getSM13Macros() {
        return new String[]{"CUDA_DOUBLE_MATH_FUNCTIONS"};
    }

    private static String[] getSM20Macros() {
        return new String[]{"CUDA_DOUBLE_MATH_FUNCTIONS", "__CUDANVVM__"};
    }

    public static String[][] getVersionAgnosticMacros() {
        return VERSION_AGNOSTIC;
    }

    public static void setCurrent(SMVersion current) {
        SMVersion.current = current;
    }

    private SMVersion(String arch, String[] macros) {
        this.arch = arch;
        this.macros = macros;
    }

    public String getArch() {
        return this.arch;
    }

    public String[] getMacros() {
        return this.macros;
    }
}

