/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.util;

import com.nvidia.cuda.ide.editor.Activator;
import com.nvidia.cuda.ide.util.IMarkerScope;
import com.nvidia.cuda.ide.util.ISourceIntegration;
import com.nvidia.cuda.ide.util.ISourceMarker;
import com.nvidia.cuda.ide.util.ResourceNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class CdtSourceIntegration
implements ISourceIntegration {
    private static final String ATTRIBUTE_SCOPE = "com.nvidia.cuda.ide.editor.scope";
    private static final String ATTRIBUTE_TYPE = "com.nvidia.cuda.ide.editor.type";
    private static final String MARKER_TYPE = "com.nvidia.cuda.ide.editor.cudaAnnotation";
    private static final String PROJECT_NAME = "__nsightsettings";
    private final Map<ISourceMarker, IMarker> markers = new HashMap<ISourceMarker, IMarker>();

    private static IStatus createStatus(String format, Object ... args) {
        String message = String.format(format, args);
        return new Status(4, "com.nvidia.cuda.ide.editor", message);
    }

    private static String getExternalFileEditorId() {
        if (Activator.getDefault().getPreferenceStore().getBoolean("externalFilesWritable")) {
            return "org.eclipse.cdt.ui.editor.CEditor";
        }
        return "com.nvidia.cuda.ide.editor.sourceviewer";
    }

    private static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private static URI verifyURISchema(URI uri) throws CoreException {
        if (uri.getScheme() == null) {
            try {
                return new URI("file", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.editor", String.format("Malformed URI: %s", uri), (Throwable)e));
            }
        }
        return uri;
    }

    @Override
    public void addMarkers(IProgressMonitor monitor, ISourceMarker ... markers) throws CoreException {
        IWorkspace workspace = CdtSourceIntegration.getWorkspace();
        workspace.run((IWorkspaceRunnable)new AddMarkers(workspace, markers), monitor);
    }

    public synchronized void ensureProjectExists() {
        if (!this.projectExists()) {
            IWorkspace workspace = CdtSourceIntegration.getWorkspace();
            IProjectDescription projectDescription = workspace.newProjectDescription(PROJECT_NAME);
            IProject project = workspace.getRoot().getProject(projectDescription.getName());
            try {
                project.create(projectDescription, 4096, (IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
                CProjectNature.addCNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
                CCProjectNature.addCCNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
                CCorePlugin.getDefault().getCoreModel().getCModel().makeConsistent((IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException e) {
                Activator.log(e);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    protected IFile getFile(ISourceMarker marker) throws CoreException {
        IProject project;
        URI uri = CdtSourceIntegration.verifyURISchema(marker.getResource());
        IFileStore store = EFS.getStore((URI)uri);
        IFileInfo info = store.fetchInfo();
        if (!info.exists()) {
            throw new ResourceNotFoundException(marker);
        }
        if (info.isDirectory()) {
            throw new CoreException(CdtSourceIntegration.createStatus(String.format("%s is a directory", uri), new Object[0]));
        }
        IFile[] files = CdtSourceIntegration.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (files.length == 0) {
            return null;
        }
        if (files.length > 1 && (project = (IProject)marker.getScope().getAdapter(IProject.class)) != null) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.getProject().equals((Object)project)) {
                    return file;
                }
                ++n2;
            }
        }
        return files[0];
    }

    @Override
    public void openEditor(ISourceMarker marker) throws CoreException {
        IMarker m = this.markers.get(marker);
        if (m == null) {
            throw new CoreException(CdtSourceIntegration.createStatus("Marker %s was not added", marker));
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (m.getResource().getType() == 1) {
            IDE.openEditor((IWorkbenchPage)page, (IMarker)m);
        } else {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (URI)CdtSourceIntegration.verifyURISchema(marker.getResource()), (String)CdtSourceIntegration.getExternalFileEditorId(), (boolean)true);
            if (editor != null) {
                IDE.gotoMarker((IEditorPart)editor, (IMarker)m);
            }
        }
    }

    @Override
    public void openEditor(URI uri) throws CoreException {
        URI verified = CdtSourceIntegration.verifyURISchema(uri);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile[] files = CdtSourceIntegration.getWorkspace().getRoot().findFilesForLocationURI(verified);
        if (files.length == 0) {
            if (!this.projectExists()) {
                try {
                    CdtSourceIntegration.getWorkspace().run((IWorkspaceRunnable)new EnsureProjectExists(), null);
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            IDE.openEditor((IWorkbenchPage)page, (URI)verified, (String)CdtSourceIntegration.getExternalFileEditorId(), (boolean)true);
        } else {
            IDE.openEditor((IWorkbenchPage)page, (IFile)files[0]);
        }
    }

    private boolean projectExists() {
        try {
            ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
            if (projects.length == 0) {
                return CdtSourceIntegration.getWorkspace().getRoot().getProject(PROJECT_NAME).isAccessible();
            }
            return true;
        }
        catch (CModelException e) {
            Activator.log(e);
            return false;
        }
    }

    @Override
    public void removeMarkers(IProgressMonitor monitor, IMarkerScope scope) throws CoreException {
        CdtSourceIntegration.getWorkspace().run((IWorkspaceRunnable)new RemoveScopedMarkers(scope), monitor);
    }

    @Override
    public void removeMarkers(IProgressMonitor monitor, ISourceMarker ... markers) throws CoreException {
        CdtSourceIntegration.getWorkspace().run((IWorkspaceRunnable)new RemoveMarkers(markers), monitor);
    }

    private final class AddMarkers
    implements IWorkspaceRunnable {
        private final ISourceMarker[] markers;
        private final IWorkspaceRoot root;

        public AddMarkers(IWorkspace workspace, ISourceMarker[] markers) {
            this.root = workspace.getRoot();
            this.markers = markers;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Adding source markers", (int)this.markers.length);
            ISourceMarker[] iSourceMarkerArray = this.markers;
            int n = this.markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m;
                ISourceMarker marker = iSourceMarkerArray[n2];
                if (CdtSourceIntegration.this.markers.containsKey(marker)) {
                    throw new CoreException(CdtSourceIntegration.createStatus("Marker %s already added", new Object[]{marker}));
                }
                IFile file = CdtSourceIntegration.this.getFile(marker);
                if (file == null) {
                    CdtSourceIntegration.this.ensureProjectExists();
                    m = this.root.createMarker(CdtSourceIntegration.MARKER_TYPE);
                    m.setAttribute("problem.externalLocation", (Object)marker.getResource().getPath());
                } else {
                    m = file.createMarker(CdtSourceIntegration.MARKER_TYPE);
                }
                m.setAttribute("lineNumber", marker.getLineNumber());
                m.setAttribute("message", (Object)marker.getDescription());
                m.setAttribute(CdtSourceIntegration.ATTRIBUTE_TYPE, (Object)marker.getTypeId());
                m.setAttribute(CdtSourceIntegration.ATTRIBUTE_SCOPE, (Object)marker.getScope().getLabel());
                CdtSourceIntegration.this.markers.put(marker, m);
                subMonitor.worked(1);
                ++n2;
            }
            monitor.done();
        }
    }

    private final class EnsureProjectExists
    implements IWorkspaceRunnable {
        private EnsureProjectExists() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            CdtSourceIntegration.this.ensureProjectExists();
        }
    }

    private final class RemoveMarkers
    implements IWorkspaceRunnable {
        private final ISourceMarker[] markers;

        public RemoveMarkers(ISourceMarker[] markers) {
            this.markers = markers;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
            mon.beginTask("Removing markers", this.markers.length);
            ISourceMarker[] iSourceMarkerArray = this.markers;
            int n = this.markers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceMarker marker = iSourceMarkerArray[n2];
                IMarker m = (IMarker)CdtSourceIntegration.this.markers.remove(marker);
                if (m != null) {
                    m.delete();
                }
                mon.worked(1);
                ++n2;
            }
            monitor.done();
        }
    }

    private final class RemoveScopedMarkers
    implements IWorkspaceRunnable {
        private final IMarkerScope scope;

        public RemoveScopedMarkers(IMarkerScope scope) {
            this.scope = scope;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
            Map table = CdtSourceIntegration.this.markers;
            mon.beginTask("Removing markers", table.size());
            Set set = table.entrySet();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (this.scope == null || ((ISourceMarker)entry.getKey()).getScope().equals(this.scope)) {
                    i.remove();
                    ((IMarker)entry.getValue()).delete();
                }
                mon.worked(1);
            }
            monitor.done();
        }
    }
}

