/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.team.internal.ccvs.core.CVSProjectSetCapability;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class CVSRepositoryLocationMatcher {
    private static final String EXTSSH = "extssh";
    private static final String PSERVER = "pserver";
    private static final String EXT = "ext";
    private static Comparator COMPATIBLE_LOCATIONS_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ICVSRepositoryLocation && o2 instanceof ICVSRepositoryLocation) {
                String name2;
                ICVSRepositoryLocation rl1 = (ICVSRepositoryLocation)o1;
                ICVSRepositoryLocation rl2 = (ICVSRepositoryLocation)o2;
                String name1 = rl1.getMethod().getName();
                if (!name1.equals(name2 = rl2.getMethod().getName()) && CVSRepositoryLocationMatcher.isCompatible(rl1, rl2, false)) {
                    if (name1.equals(CVSRepositoryLocationMatcher.EXTSSH)) {
                        return -1;
                    }
                    if (name2.equals(CVSRepositoryLocationMatcher.EXTSSH)) {
                        return 1;
                    }
                    if (name1.equals(CVSRepositoryLocationMatcher.PSERVER)) {
                        return -1;
                    }
                    if (name2.equals(CVSRepositoryLocationMatcher.PSERVER)) {
                        return 1;
                    }
                    if (name1.equals(CVSRepositoryLocationMatcher.EXT)) {
                        return -1;
                    }
                    if (name2.equals(CVSRepositoryLocationMatcher.EXT)) {
                        return 1;
                    }
                }
                return name1.compareTo(name2);
            }
            return 0;
        }
    };

    public static Map prepareSuggestedRepositoryLocations(IProject[] projects, Map infoMap) {
        Iterator i;
        HashMap result;
        List<IProject> confirmedProjectsList = Arrays.asList(projects);
        HashSet<ICVSRepositoryLocation> projectSetRepositoryLocations = new HashSet<ICVSRepositoryLocation>();
        Iterator i2 = infoMap.keySet().iterator();
        while (i2.hasNext()) {
            IProject project = (IProject)i2.next();
            if (!confirmedProjectsList.contains(project)) continue;
            CVSProjectSetCapability.LoadInfo loadInfo = (CVSProjectSetCapability.LoadInfo)infoMap.get(project);
            projectSetRepositoryLocations.add(loadInfo.repositoryLocation);
        }
        if (projectSetRepositoryLocations.isEmpty()) {
            return null;
        }
        List<ICVSRepositoryLocation> knownRepositories = Arrays.asList(KnownRepositories.getInstance().getRepositories());
        if (knownRepositories.isEmpty()) {
            result = new HashMap();
            i = projectSetRepositoryLocations.iterator();
            while (i.hasNext()) {
                ICVSRepositoryLocation projectSetRepositoryLocation = (ICVSRepositoryLocation)i.next();
                ArrayList<ICVSRepositoryLocation> list = new ArrayList<ICVSRepositoryLocation>(1);
                list.add(projectSetRepositoryLocation);
                result.put(projectSetRepositoryLocation, list);
            }
            return result;
        }
        if (knownRepositories.containsAll(projectSetRepositoryLocations)) {
            return Collections.EMPTY_MAP;
        }
        result = new HashMap();
        i = projectSetRepositoryLocations.iterator();
        while (i.hasNext()) {
            ICVSRepositoryLocation projectSetRepositoryLocation = (ICVSRepositoryLocation)i.next();
            ArrayList<ICVSRepositoryLocation> matching = new ArrayList<ICVSRepositoryLocation>();
            ArrayList<ICVSRepositoryLocation> compatible = new ArrayList<ICVSRepositoryLocation>();
            ArrayList<ICVSRepositoryLocation> list = new ArrayList<ICVSRepositoryLocation>();
            Iterator<ICVSRepositoryLocation> j = knownRepositories.iterator();
            while (j.hasNext()) {
                ICVSRepositoryLocation knownRepositoryLocation = j.next();
                if (CVSRepositoryLocationMatcher.isMatching(projectSetRepositoryLocation, knownRepositoryLocation)) {
                    matching.add(knownRepositoryLocation);
                    continue;
                }
                if (CVSRepositoryLocationMatcher.isCompatible(knownRepositoryLocation, projectSetRepositoryLocation, false)) {
                    compatible.add(knownRepositoryLocation);
                    continue;
                }
                list.add(knownRepositoryLocation);
            }
            Collections.sort(compatible, COMPATIBLE_LOCATIONS_COMPARATOR);
            list.addAll(0, compatible);
            if (matching.isEmpty()) {
                list.add(0, projectSetRepositoryLocation);
            } else {
                if (matching.size() == 1) {
                    list.clear();
                    list.addAll(matching);
                    result.put(projectSetRepositoryLocation, list);
                    continue;
                }
                list.addAll(0, matching);
            }
            result.put(projectSetRepositoryLocation, list);
        }
        return result;
    }

    public static boolean isCompatible(ICVSRepositoryLocation location1, ICVSRepositoryLocation location2, boolean equalIsCompatible) {
        if (!location1.getHost().equals(location2.getHost())) {
            return false;
        }
        if (!location1.getRootDirectory().equals(location2.getRootDirectory())) {
            return false;
        }
        return equalIsCompatible || !location1.equals(location2);
    }

    public static boolean isMatching(ICVSRepositoryLocation location1, ICVSRepositoryLocation location2) {
        return CVSRepositoryLocationMatcher.isCompatible(location1, location2, true) && location2.getMethod() == location1.getMethod() && location2.getPort() == location1.getPort();
    }

    static boolean isPromptRequired(Map suggestedRepositoryLocations) {
        if (suggestedRepositoryLocations == null) {
            return false;
        }
        Iterator i = suggestedRepositoryLocations.values().iterator();
        while (i.hasNext()) {
            List list = (List)i.next();
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

