grammar FilterString;

options {
  language = Java;
}

@header {
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters.parser;
  
import com.nvidia.cuda.ide.debug.model.query.*;
}

@lexer::header {
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters.parser;
}

@members {
public FilterFactory factory = new FilterFactory();
}

@lexer::members {
@Override
public void reportError(RecognitionException e) {
	throw new IllegalArgumentException(e);
}
}

@rulecatch {
catch (RecognitionException e) {
  throw e;
}
}

filters
  :
  filter filter*
  ;

filter
  :
  elementFilter
  ;

elementFilter
  :
  device
  | sm
  | warp
  | lane
  | kernel
  | block
  | thread
  ;

device
  :
  'device' scalar 
                 {
                  factory.createDeviceFilter($scalar.scalar);
                 }
  ;

sm
  :
  'sm' scalar 
             {
              factory.createSMFilter($scalar.scalar);
             }
  ;

warp
  :
  'warp' scalar 
               {
                factory.createWarpFilter($scalar.scalar);
               }
  ;

lane
  :
  'lane' scalar 
               {
                factory.createLaneFilter($scalar.scalar);
               }
  ;

kernel
  :
  'kernel' scalar 
                 {
                  factory.createKernelFilter($scalar.scalar);
                 }
  ;

block
  :
  'block' cudim3 
                {
                 factory.createBlockFilter($cudim3.cudim3);
                }
  ;

thread
  :
  'thread' cudim3 
                 {
                  factory.createThreadFilter($cudim3.cudim3);
                 }
  | cudim3 
          {
           factory.createThreadFilter($cudim3.cudim3);
          }
  ;

scalar returns [int scalar]
  :
  '(' x ')' 
           {
            $scalar = $x.x;
           }
  | x 
     {
      $scalar = $x.x;
     }
  ;

cudim3 returns [Dim3Filter cudim3]
  :
  '(' triplet ')' 
                 {
                  $cudim3 = $triplet.coord;
                 }
  | triplet 
           {
            $cudim3 = $triplet.coord;
           }
  ;

triplet returns [Dim3Filter coord]
  :
  x ',' y ',' z 
               {
                $coord = new Dim3Filter($x.x, $y.y, $z.z);
               }
  | x ',' y 
           {
            $coord = new Dim3Filter($x.x, $y.y, -1);
           }
  | id 
      {
       $coord = new Dim3Filter($id.id, -1, -1);
      }
  ;

x returns [int x]
  :
  id 
    {
     $x = $id.id;
    }
  ;

y returns [int y]
  :
  id 
    {
     $y = $id.id;
    }
  ;

z returns [int z]
  :
  id 
    {
     $z = $id.id;
    }
  ;

id returns [int id]
  :
  Digits 
        {
         $id = Integer.parseInt($text);
        }
  | '*' 
       {
        $id = -1;
       }
  ;

Digits
  :
  ('0'..'9') ('0'..'9')*
  ;

WS
  :
  (
    ' '
    | '\t'
    | '\r' '\n'
    | '\n'
  )
  
  {
   $channel = HIDDEN;
  }
  ;
