/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class ContextServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_ID = "id";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response = this.processRequest(req, resp);
        if ("400".equals(response)) {
            resp.sendError(400);
        } else if ("404".equals(response)) {
            resp.sendError(404);
        } else {
            resp.getWriter().write(response);
        }
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BaseHelpSystem.checkMode();
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        String id = req.getParameter(PARAMETER_ID);
        if (id != null) {
            IContext context = this.getContext(locale, id);
            if (context != null) {
                return this.serialize(context);
            }
            return "404";
        }
        return "400";
    }

    protected IContext getContext(String locale, String id) {
        IContext context = HelpPlugin.getContextManager().getContext(id, locale);
        return context;
    }

    private String serialize(IContext context) throws IOException {
        String title;
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buff.append("<context");
        if (context instanceof IContext2 && (title = ((IContext2)context).getTitle()) != null && title.length() > 0) {
            buff.append(" title=\"" + title + "\"");
        }
        buff.append(">\n");
        String description = context.getText();
        if (description != null) {
            buff.append("   <description>" + UrlUtil.htmlEncode(description) + "</description>\n");
        }
        IHelpResource[] topics = context.getRelatedTopics();
        int i = 0;
        while (i < topics.length) {
            buff.append("   <topic");
            if (topics[i].getLabel() != null) {
                buff.append("\n         label=\"" + topics[i].getLabel() + '\"');
            }
            if (topics[i].getHref() != null) {
                buff.append("\n         href=\"" + topics[i].getHref() + '\"');
            }
            buff.append(">   </topic>\n");
            ++i;
        }
        buff.append("</context>\n");
        return buff.toString();
    }
}

