/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PushbuttonField;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.arguments.filters.U3DFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Add3D
extends AbstractTool {
    FileArgument destfile = null;
    public static final String PDF_NAME_3D = "3D";
    public static final String PDF_NAME_3DD = "3DD";
    public static final String PDF_NAME_3DV = "3DV";
    public static final String PDF_NAME_3DVIEW = "3DView";
    public static final String PDF_NAME_C2W = "C2W";
    public static final String PDF_NAME_IN = "IN";
    public static final String PDF_NAME_MS = "MS";
    public static final String PDF_NAME_U3D = "U3D";
    public static final String PDF_NAME_XN = "XN";

    public Add3D() {
        this.menuoptions = 3;
        FileArgument fileArgument = new FileArgument(this, "srcfile", "The file you want to add the u3d File", false, new PdfFilter());
        this.arguments.add(fileArgument);
        FileArgument fileArgument2 = new FileArgument(this, "srcu3dfile", "The u3d file you want to add", false, new U3DFilter());
        this.arguments.add(fileArgument2);
        StringArgument stringArgument = new StringArgument(this, "pagenumber", "The pagenumber where to add the u3d annotation");
        stringArgument.setValue("1");
        this.arguments.add(stringArgument);
        this.destfile = new FileArgument(this, "destfile", "The file that contains the u3d annotation after processing", true, new PdfFilter());
        this.arguments.add(this.destfile);
        fileArgument.addPropertyChangeListener(this.destfile);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Add3D", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Add3D OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("srcu3dfile") == null) {
                throw new InstantiationException("You need to choose a u3d file");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            int n = Integer.parseInt((String)this.getValue("pagenumber"));
            PdfReader pdfReader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            String string = ((File)this.getValue("srcu3dfile")).getAbsolutePath();
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream((File)this.getValue("destfile")));
            PdfWriter pdfWriter = pdfStamper.getWriter();
            PdfContentByte pdfContentByte = pdfStamper.getUnderContent(n);
            Rectangle rectangle = pdfReader.getCropBox(n);
            Rectangle rectangle2 = new Rectangle(new Rectangle(100.0f, rectangle.getHeight() - 550.0f, rectangle.getWidth() - 100.0f, rectangle.getHeight() - 150.0f));
            PdfStream pdfStream = new PdfStream(PdfEncodings.convertToBytes("runtime.setCurrentTool(\"Rotate\");", null));
            pdfStream.flateCompress();
            PdfStream pdfStream2 = new PdfStream(new FileInputStream(string), pdfWriter);
            pdfStream2.put(new PdfName("OnInstantiate"), pdfWriter.addToBody(pdfStream).getIndirectReference());
            pdfStream2.put(PdfName.TYPE, new PdfName(PDF_NAME_3D));
            pdfStream2.put(PdfName.SUBTYPE, new PdfName(PDF_NAME_U3D));
            pdfStream2.flateCompress();
            PdfIndirectReference pdfIndirectReference = pdfWriter.addToBody(pdfStream2).getIndirectReference();
            pdfStream2.writeLength();
            PdfDictionary pdfDictionary = new PdfDictionary(new PdfName(PDF_NAME_3DVIEW));
            pdfDictionary.put(new PdfName(PDF_NAME_XN), new PdfString("Default"));
            pdfDictionary.put(new PdfName(PDF_NAME_IN), new PdfString("Unnamed"));
            pdfDictionary.put(new PdfName(PDF_NAME_MS), PdfName.M);
            pdfDictionary.put(new PdfName(PDF_NAME_C2W), new PdfArray(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 3.0f, -235.0f, 28.0f}));
            pdfDictionary.put(PdfName.CO, new PdfNumber(235));
            PdfIndirectObject pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            PdfAppearance pdfAppearance = pdfContentByte.createAppearance(rectangle2.getRight() - rectangle2.getLeft(), rectangle2.getTop() - rectangle2.getBottom());
            pdfAppearance.setBoundingBox(rectangle2);
            PdfAnnotation pdfAnnotation = new PdfAnnotation(pdfWriter, rectangle2);
            pdfAnnotation.put(PdfName.CONTENTS, new PdfString("3D Model"));
            pdfAnnotation.put(PdfName.SUBTYPE, new PdfName(PDF_NAME_3D));
            pdfAnnotation.put(PdfName.TYPE, PdfName.ANNOT);
            pdfAnnotation.put(new PdfName(PDF_NAME_3DD), pdfIndirectReference);
            pdfAnnotation.put(new PdfName(PDF_NAME_3DV), pdfIndirectObject.getIndirectReference());
            pdfAnnotation.put(new PdfName("3DI"), PdfBoolean.PDFFALSE);
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.A, new PdfName("PO"));
            pdfDictionary2.put(new PdfName("DIS"), PdfName.I);
            pdfAnnotation.put(new PdfName("3DA"), pdfDictionary2);
            pdfAnnotation.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
            pdfAnnotation.setPage();
            pdfStamper.addAnnotation(pdfAnnotation, n);
            Add3D.AddButton(100.0f, 100.0f, "Rotate", "im = this.getAnnots3D(0)[0].context3D;\rim.runtime.setCurrentTool(\"Rotate\");", "rotate.png", pdfWriter);
            Add3D.AddButton(150.0f, 100.0f, "Pan", "im = this.getAnnots3D(0)[0].context3D;\rim.runtime.setCurrentTool(\"Pan\");", "translate.png", pdfWriter);
            Add3D.AddButton(200.0f, 100.0f, "Zoom", "im = this.getAnnots3D(0)[0].context3D;\rim.runtime.setCurrentTool(\"Zoom\");", "zoom.png", pdfWriter);
            pdfStamper.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public static void AddButton(float f, float f2, String string, String string2, String string3, PdfWriter pdfWriter) {
        try {
            Image image = Image.getInstance(string3);
            PushbuttonField pushbuttonField = new PushbuttonField(pdfWriter, new Rectangle(f, f2, f + image.getPlainWidth(), f2 + image.getPlainHeight()), string);
            pushbuttonField.setLayout(2);
            pushbuttonField.setImage(image);
            PdfFormField pdfFormField = pushbuttonField.getField();
            PdfAction pdfAction = PdfAction.javaScript(string2, pdfWriter);
            pdfFormField.setAction(pdfAction);
            pdfWriter.addAnnotation(pdfFormField);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (BadElementException badElementException) {
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
        if (this.destfile.getValue() == null && abstractArgument.getName().equalsIgnoreCase("srcfile")) {
            String string = abstractArgument.getValue().toString();
            String string2 = string.substring(0, string.indexOf(".", string.length() - 4)) + "_out.pdf";
            this.destfile.setValue(string2);
        }
    }

    public static void main(String[] stringArray) {
        Add3D add3D = new Add3D();
        if (stringArray.length != 4) {
            System.err.println(add3D.getUsage());
        }
        add3D.setMainArguments(stringArray);
        add3D.execute();
    }

    static {
        Add3D.addVersion("$Id: Add3D.java 3373 2008-05-12 16:21:24Z xlv $");
    }
}

