/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.nvccsupport;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.build.project.BuildUtils;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.ProjectMetaManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.core.runtime.CoreException;

public class LinkerCommandLineGenerator
extends ManagedCommandLineGenerator {
    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        IConfiguration parent = tool.getParentResourceInfo().getParent();
        ICConfigurationDescription description = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)parent);
        try {
            ICudaProjectConfiguration projectConfiguration = ProjectMetaManager.load(description);
            flags = this.addArchitectures(projectConfiguration, flags);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        Cpu cpu = BuildUtils.getCpu(tool);
        flags = (String[])CoreUtil.join((Object[])flags, (Object[])cpu.getNvccFlags());
        flags = BuildUtils.addCcbinSwitch(flags, cpu);
        return super.generateCommandLineInfo(tool, BuildUtils.getNvccPath(tool), flags, outputFlag, outputPrefix, outputName, inputResources, commandLinePattern);
    }

    private String[] addArchitectures(ICudaProjectConfiguration config, String[] flags) {
        return (String[])CoreUtil.join((Object[])flags, (Object[])BuildUtils.getSMVersionFlags(config.getExecutable(), true));
    }
}

