/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.List;
import org.eclipse.e4.ui.internal.workbench.BundleFinder;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PI_WORKBENCH = "org.eclipse.e4.ui.workbench";
    private static Activator activator;
    private BundleContext context;
    private ServiceTracker<Location, Location> locationTracker;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker;
    private ServiceTracker<LogService, LogService> logTracker;
    private BundleTracker<List<Bundle>> resolvedBundles;
    private final BundleFinder bundleFinder = new BundleFinder();
    private DebugTrace trace;

    public static Activator getDefault() {
        return activator;
    }

    public Bundle getBundle() {
        return this.context.getBundle();
    }

    public Bundle getBundleForName(String bundleName) {
        return this.bundleFinder.findBundle(bundleName);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public Location getInstanceLocation() {
        if (this.locationTracker == null) {
            Filter filter = null;
            try {
                filter = this.context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.locationTracker = new ServiceTracker(this.context, filter, null);
            this.locationTracker.open();
        }
        return (Location)this.locationTracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        activator = this;
        this.context = context;
        this.resolvedBundles = new BundleTracker(context, 60, (BundleTrackerCustomizer)this.bundleFinder);
        this.resolvedBundles.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.locationTracker != null) {
            this.locationTracker.close();
            this.locationTracker = null;
        }
        if (this.debugTracker != null) {
            this.trace = null;
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.resolvedBundles != null) {
            this.resolvedBundles.close();
            this.resolvedBundles = null;
        }
    }

    public DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            if (this.context == null) {
                return null;
            }
            this.debugTracker = new ServiceTracker(this.context, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public DebugTrace getTrace() {
        if (this.trace == null) {
            this.trace = this.getDebugOptions().newDebugTrace(PI_WORKBENCH);
        }
        return this.trace;
    }

    public static void trace(String option, String msg, Throwable error) {
        DebugOptions debugOptions = activator.getDebugOptions();
        if (debugOptions.isDebugEnabled() && debugOptions.getBooleanOption(PI_WORKBENCH + option, false)) {
            System.out.println(msg);
            if (error != null) {
                error.printStackTrace(System.out);
            }
        }
        activator.getTrace().trace(option, msg, error);
    }

    public LogService getLogService() {
        LogService logService = null;
        if (this.logTracker != null) {
            logService = (LogService)this.logTracker.getService();
        } else if (this.context != null) {
            this.logTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logTracker.open();
            logService = (LogService)this.logTracker.getService();
        }
        if (logService == null) {
            logService = new LogService(){

                public void log(int level, String message) {
                    this.log(null, level, message, null);
                }

                public void log(int level, String message, Throwable exception) {
                    this.log(null, level, message, exception);
                }

                public void log(ServiceReference sr, int level, String message) {
                    this.log(sr, level, message, null);
                }

                public void log(ServiceReference sr, int level, String message, Throwable exception) {
                    if (level == 1) {
                        System.err.print("ERROR: ");
                    } else if (level == 2) {
                        System.err.print("WARNING: ");
                    } else if (level == 3) {
                        System.err.print("INFO: ");
                    } else if (level == 4) {
                        System.err.print("DEBUG: ");
                    } else {
                        System.err.print("log level " + level + ": ");
                    }
                    System.err.println(message);
                    if (exception != null) {
                        exception.printStackTrace(System.err);
                    }
                }
            };
        }
        return logService;
    }

    public static void log(int level, String message) {
        LogService logService = activator.getLogService();
        if (logService != null) {
            logService.log(level, message);
        }
    }

    public static void log(int level, String message, Throwable exception) {
        LogService logService = activator.getLogService();
        if (logService != null) {
            logService.log(level, message, exception);
        }
    }
}

