/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.team.ui.mapping.ITeamStateDescription;

public class TeamStateDescription
implements ITeamStateDescription {
    private int state;
    private Map properties = new HashMap();

    public TeamStateDescription(int state) {
        this.state = state;
    }

    public int getStateFlags() {
        return this.state;
    }

    public int getKind() {
        return this.getStateFlags() & 0xFF;
    }

    public int getDirection() {
        return this.getStateFlags() & 0x300;
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TeamStateDescription) {
            TeamStateDescription dsd = (TeamStateDescription)obj;
            if (dsd.getStateFlags() == this.state && this.haveSameProperties(this, dsd)) {
                String[] properties = this.getPropertyNames();
                int i = 0;
                while (i < properties.length) {
                    Object o2;
                    String property = properties[i];
                    Object o1 = this.getProperty(property);
                    if (!o1.equals(o2 = dsd.getProperty(property))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return super.equals(obj);
    }

    private boolean haveSameProperties(TeamStateDescription d1, TeamStateDescription d2) {
        String[] p2;
        String[] p1 = d1.getPropertyNames();
        if (p1.length != (p2 = d2.getPropertyNames()).length) {
            return false;
        }
        int i = 0;
        while (i < p1.length) {
            String s1 = p1[i];
            boolean found = false;
            int j = 0;
            while (j < p2.length) {
                String s2 = p2[j];
                if (s1.equals(s2)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

