/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class PushBranchActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        Ref branchRef = this.getBranchRef(repository);
        if (branchRef != null) {
            PushBranchWizard wizard = new PushBranchWizard(repository, branchRef);
            WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wizard);
            dlg.open();
        }
        return null;
    }

    public boolean isEnabled() {
        Repository repository = this.getRepository();
        if (repository == null) {
            return false;
        }
        return this.getBranchRef(repository) != null;
    }

    private Ref getBranchRef(Repository repository) {
        try {
            String fullBranch = repository.getFullBranch();
            if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                return repository.getRef(fullBranch);
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

