/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.devices;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.common.device.ICudaDeviceManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.sdk.CudaSDKCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class CudaDevice {
    private static final int DEVICE_DETECTION_TIMEOUT = 2500;
    private static final ICudaDevice[] NO_CUDA_DEVICES = new ICudaDevice[0];
    private static Boolean previousResponse = null;
    public static final String VISIBLE_DEVICES_ENV_VAR = "CUDA_VISIBLE_DEVICES";

    private static boolean askUser() {
        if (previousResponse != null) {
            return previousResponse;
        }
        final boolean[] response = new boolean[1];
        if (Display.getCurrent() != null) {
            CudaDevice.showQuestionDialog(response);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CudaDevice.showQuestionDialog(response);
                }
            });
        }
        if (response[0]) {
            return true;
        }
        previousResponse = Boolean.FALSE;
        return previousResponse;
    }

    public static boolean devicesFilteredExternally() {
        return System.getenv(VISIBLE_DEVICES_ENV_VAR) != null;
    }

    private static synchronized ICudaDevice[] getDevices(final boolean prompt) {
        try {
            return (ICudaDevice[])CoreUtil.accessService(ICudaDeviceManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<ICudaDeviceManager, ICudaDevice[]>(){

                public ICudaDevice[] runWithService(ICudaDeviceManager service) throws CoreException {
                    while (true) {
                        try {
                            return service.getDevices(2500L);
                        }
                        catch (TimeoutException timeoutException) {
                            if (prompt && CudaDevice.askUser()) continue;
                            return NO_CUDA_DEVICES;
                        }
                        break;
                    }
                }
            });
        }
        catch (CoreException e) {
            CudaSDKCore.log(e);
            return NO_CUDA_DEVICES;
        }
    }

    public static ICudaDevice[] getDevices(boolean prompt, String filter) {
        Object[] devices = CudaDevice.getDevices(prompt);
        if (CoreUtil.isNullOrEmpty((Object[])devices) || CoreUtil.isNullOrEmpty((String)filter)) {
            return devices;
        }
        HashSet<String> split = new HashSet<String>(Arrays.asList(filter.split(",")));
        ArrayList<Object> filtered = new ArrayList<Object>(devices.length);
        Object[] objectArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Object device = objectArray[n2];
            if (split.contains(String.valueOf(device.getOrdinal()))) {
                filtered.add(device);
            }
            ++n2;
        }
        return filtered.toArray(new ICudaDevice[filtered.size()]);
    }

    public static ICudaDevice[] getDevices(String filter) {
        return CudaDevice.getDevices(true, filter);
    }

    private static void showQuestionDialog(boolean[] response) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "CUDA IDE", null, "Timed out querying for the list of devices. It is likely that the device is suspended on a breakpoint. Do you want to retry detecting the devices?", 1, new String[]{"Retry", "Cancel"}, 0);
        response[0] = dialog.open() == 0;
    }

    private CudaDevice() {
    }

    public static boolean areDevicesRead() {
        return false;
    }
}

