/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.sdk.internal;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.sdk.CudaSDKCore;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Version;

public class WorkspaceUpgradeAgent
implements IStartup {
    private static final String WORKSPACE_VERSION_PREFERENCE = "workspace.version";
    private static final Version CURRENT = CudaSDKCore.getDefault().getBundle().getVersion();

    public void earlyStartup() {
        IPreferenceStore store = CudaSDKCore.getDefault().getPreferenceStore();
        String version = store.getString(WORKSPACE_VERSION_PREFERENCE);
        Version v = new Version(0, 0, 0);
        try {
            v = Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (v.compareTo(CURRENT) < 0) {
            this.upgradeWorkspace(v);
            store.setValue(WORKSPACE_VERSION_PREFERENCE, CURRENT.toString());
        }
    }

    private void upgradeWorkspace(Version workspaceVersion) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("com.nvidia.cuda.ide.sdk", "workspaceUpgrader");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement element = iConfigurationElementArray[n2];
            String version = element.getAttribute("version");
            try {
                if (CoreUtil.isNullOrEmpty((String)version)) {
                    throw new IllegalArgumentException();
                }
                Version v = Version.parseVersion((String)version);
                if (v.compareTo(workspaceVersion) > 0) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            Runnable runnable = (Runnable)element.createExecutableExtension("class");
                            runnable.run();
                        }

                        public void handleException(Throwable exception) {
                            CudaSDKCore.log(exception, "Workspace upgrade process contributed by plugin %s failed with following exception", element.getContributor().getName());
                        }
                    });
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CudaSDKCore.log("\"%s\" is not a valid version string (workspace upgrader contributed from %s plugin)", version, element.getContributor().getName());
            }
            ++n2;
        }
    }
}

