/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public enum CuptiActivityAttributeKind {
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE(0),
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP(1),
    CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT(2);

    private final int attrCode;
    private int value = -1;

    private CuptiActivityAttributeKind(int code) {
        this.attrCode = code;
    }

    public int getValue() {
        if (this.value == -1) {
            try {
                this.value = NativeCupti.cuptiActivityGetAttribute(this.attrCode);
            }
            catch (CuptiException cuptiException) {
                this.value = 0;
            }
        }
        return this.value;
    }

    public int getValue(ValueUnit unit) {
        int value = this.getValue();
        switch (unit) {
            case B: {
                return value;
            }
            case KB: {
                return value / 1024;
            }
            case MB: {
                return value / 0x100000;
            }
            case GB: {
                return value / 0x40000000;
            }
        }
        return value;
    }

    public static enum ValueUnit {
        B,
        KB,
        MB,
        GB;

    }
}

