/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystemException;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.fs.RemoteFileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.NvprofResult;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public abstract class FileSystem {
    private static String NVPROF_LOG_FILE_NAME = "nvprof.log";
    private static String NVPROF_LOG_FILE_NAME_MULTI_PROCESS = "nvprof_%p.log";
    private static String NVPROF_LOG_FILE_NAME_MPI_PROCESS = "nvprof_%h.%p.log";
    private static final Map<String, FileSystem> delegates = new HashMap<String, FileSystem>();

    protected String getNvprofLogFileName(Executable exe) {
        if (exe != null && exe.isMultiProcess()) {
            if (exe.isMPI()) {
                return NVPROF_LOG_FILE_NAME_MPI_PROCESS;
            }
            return NVPROF_LOG_FILE_NAME_MULTI_PROCESS;
        }
        return NVPROF_LOG_FILE_NAME;
    }

    public static FileSystem getFilesystem(Session session) throws ConnectionNotFoundException {
        if (session != null && session.getExecutable() != null) {
            return FileSystem.getFilesystem(session.getExecutable().getConnectionName());
        }
        return FileSystem.getFilesystem(null);
    }

    public static synchronized FileSystem getFilesystem(String connectionName) throws ConnectionNotFoundException {
        if (!delegates.containsKey(connectionName)) {
            delegates.put(connectionName, FileSystem.newConnectionDelegate(connectionName));
        }
        return delegates.get(connectionName);
    }

    public static synchronized void removeConnections(ArrayList<String> connectionNames) {
        for (String connectionName : connectionNames) {
            delegates.remove(connectionName);
        }
    }

    private static FileSystem newConnectionDelegate(String connectionName) throws ConnectionNotFoundException {
        if (connectionName == null) {
            return new LocalFileSystem();
        }
        IRemoteConnection connection = IRemoteConnectionsService.GetConnection.getConnection((String)connectionName, null);
        if (connection == null) {
            throw new ConnectionNotFoundException(connectionName);
        }
        if (connection.isLocalSystem()) {
            return FileSystem.getFilesystem(null);
        }
        return new RemoteFileSystem(connection);
    }

    public abstract String browseForDirectory(Shell var1, String var2, String var3, String var4) throws CoreException;

    public abstract String browseForFile(Shell var1, String var2, String var3, String var4) throws CoreException;

    public abstract String[] browseForFileMulti(Shell var1, String var2, String var3, String var4) throws CoreException;

    protected void checkNvprofErrorCode(int retval) throws ViperException {
        NvprofResult result = NvprofResult.valueOf(retval);
        if (result != null) {
            ViperRunMode.setLastNvprofResult(result);
            if (!result.equals((Object)NvprofResult.NVPROF_SUCCESS)) {
                throw new ViperException(result.getMessage(this.isLocal()));
            }
        } else {
            throw new ViperException("Unknown nvprof return value: " + retval);
        }
    }

    public abstract void connect(IProgressMonitor var1) throws CoreException;

    public abstract IDevicesData getDeviceData(boolean var1) throws DeviceListNotReadyException, ViperException;

    public abstract String getName();

    public abstract boolean isConnected();

    public abstract boolean isExistingDirectory(String var1) throws FileSystemException;

    public abstract boolean isExistingFile(String var1) throws FileSystemException;

    public abstract boolean isLocal();

    public abstract boolean isRunnable(String var1);

    public abstract boolean isTimestampChanged(String var1, long var2);

    public abstract File[] runNvprof(Executable var1, String var2, String var3, IProgressMonitor var4) throws CoreException, ViperException;

    public abstract File runRebelCommandLine(Executable var1, String var2, String var3, IProgressMonitor var4) throws CoreException, ViperException;

    public abstract boolean readAndResetNvprofWarningStatus();

    public abstract boolean isCustomScript();
}

