/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.parts.TimelineRulerEditPart;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.swt.graphics.Cursor;

public class RegionOfInterestDragTracker
extends SimpleDragTracker {
    protected static final int DRAG_THRESHOLD = 3;
    private TimelineRulerEditPart source;

    public RegionOfInterestDragTracker(TimelineRulerEditPart source) {
        this.source = source;
    }

    protected boolean movedPastThreshold() {
        return Math.abs(this.getLocation().x - this.getStartLocation().x) > 3;
    }

    protected void eraseSourceFeedback() {
        this.source.clearRegionOfInterestDrag();
    }

    protected void showSourceFeedback() {
        Point startLoc = this.getStartLocation();
        Point loc = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)startLoc);
        this.source.getFigure().translateToRelative((Translatable)loc);
        this.source.showRegionOfInterestDrag(startLoc.x, loc.x);
    }

    protected void performDrag() {
        Point startLoc = this.getStartLocation();
        Point loc = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)startLoc);
        this.source.getFigure().translateToRelative((Translatable)loc);
        this.source.addRegionOfInterest(startLoc.x, loc.x);
    }

    protected Cursor getDefaultCursor() {
        return Cursors.SIZEWE;
    }

    protected String getDebugName() {
        return "Timeline Region-Of-Interest";
    }

    protected String getCommandName() {
        return "Region-Of-Interest";
    }
}

